/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.tools;

import de.dfncert.utils.crypto.CryptoUtils;
import de.dfncert.utils.crypto.DFNStyle;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class Cryptography {
    private Cryptography() {
    }

    private static void checkBC() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public static String createPKCS10(String subject, PublicKey publickey, PrivateKey privatekey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, IOException, OperatorCreationException {
        return Cryptography.createPKCS10(subject, publickey, privatekey, "SunRsaSign");
    }

    public static String createPKCS10(String subject, PublicKey publickey, PrivateKey privatekey, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, IOException, OperatorCreationException {
        ContentSigner signer;
        Cryptography.checkBC();
        JcaPKCS10CertificationRequestBuilder reqBuilder = new JcaPKCS10CertificationRequestBuilder(new X500Name((X500NameStyle)DFNStyle.INSTANCE, subject.replaceAll("\\\\,", ",")), publickey);
        try {
            signer = new JcaContentSignerBuilder("SHA256withRSA").setProvider(provider).build(privatekey);
        }
        catch (Exception ex) {
            signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider(provider).build(privatekey);
        }
        PKCS10CertificationRequest request = reqBuilder.build(signer);
        StringWriter strWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)strWriter);
        pemWriter.writeObject((Object)request);
        pemWriter.close();
        return strWriter.toString();
    }

    public static String sha1(byte[] input) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        byte[] output = digest.digest(input);
        byte[] outputhex = Hex.encode((byte[])output);
        return new String(outputhex);
    }

    public static String sha1(byte[] input, String bytesSeparator, boolean upperCase) throws NoSuchAlgorithmException {
        String hash = Cryptography.sha1(input);
        hash = upperCase ? hash.toUpperCase() : hash.toLowerCase();
        if (bytesSeparator != null) {
            int len = hash.length();
            StringBuilder result = new StringBuilder(len + len / 2);
            int i = 0;
            while (i < len) {
                result.append(hash.substring(i, i + 2));
                if (i < len - 2) {
                    result.append(bytesSeparator);
                }
                i += 2;
            }
            return result.toString();
        }
        return hash;
    }

    public static String createPKCS7Signed(byte[] text, PrivateKey privatekey, X509Certificate certificate) throws NoSuchAlgorithmException, CertStoreException, CMSException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException, OperatorCreationException, CertificateEncodingException {
        Cryptography.checkBC();
        String providerName = "BC";
        if (Security.getProvider("SunPKCS11-DFNPKIClient") != null) {
            providerName = "SunPKCS11-DFNPKIClient";
        }
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        ContentSigner sigGen = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider(providerName).build(privatekey);
        generator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(providerName).build()).build(sigGen, (X509CertificateHolder)new JcaX509CertificateHolder(certificate)));
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        list.add(certificate);
        JcaCertStore store = new JcaCertStore(list);
        generator.addCertificates((Store)store);
        CMSSignedData data = generator.generate((CMSTypedData)new CMSProcessableByteArray(text), false);
        return Cryptography.getBase64(data.getEncoded());
    }

    private static String getBase64(byte[] data) {
        String dataBase64 = new String(Base64.encode((byte[])data));
        StringBuilder pkcs7 = new StringBuilder();
        pkcs7.append("-----BEGIN PKCS7-----\n");
        int i = 0;
        while (i < dataBase64.length()) {
            if (i + 64 >= dataBase64.length()) {
                pkcs7.append(dataBase64.substring(i));
            } else {
                pkcs7.append(dataBase64.substring(i, i + 64));
            }
            pkcs7.append("\n");
            i += 64;
        }
        pkcs7.append("-----END PKCS7-----\n");
        return pkcs7.toString();
    }

    public static String createPKCS7Encrypted(byte[] data, X509Certificate[] certs) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException, CertificateEncodingException {
        Cryptography.checkBC();
        CMSEnvelopedDataGenerator cmsGenerator = new CMSEnvelopedDataGenerator();
        X509Certificate[] x509CertificateArray = certs;
        int n = certs.length;
        int n2 = 0;
        while (n2 < n) {
            X509Certificate cert = x509CertificateArray[n2];
            cmsGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(cert).setProvider("SunJCE"));
            ++n2;
        }
        JceCMSContentEncryptorBuilder ceb = new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES256_CBC).setProvider("SunJCE");
        CMSEnvelopedData enveloped = cmsGenerator.generate((CMSTypedData)new CMSProcessableByteArray(data), ceb.build());
        return Cryptography.getBase64(enveloped.getEncoded());
    }

    public static byte[] decryptPKCS7(String base64, X509Certificate cert, PrivateKey key) throws CMSException, Exception {
        return Cryptography.decryptPKCS7(base64, cert, key, "SunJCE");
    }

    public static byte[] decryptPKCS7(String base64, X509Certificate cert, PrivateKey key, String provider) throws CMSException, Exception {
        String keyString;
        base64 = base64.replaceFirst("-----BEGIN PKCS7-----\n", "");
        base64 = base64.replaceFirst("-----END PKCS7-----", "");
        byte[] data = Base64.decode((String)base64);
        Cryptography.checkBC();
        CMSEnvelopedData envParser = new CMSEnvelopedData(data);
        RecipientInformation info = null;
        JceKeyTransRecipientId rid = new JceKeyTransRecipientId(cert);
        info = envParser.getRecipientInfos().get((RecipientId)rid);
        if (info == null) {
            throw new Exception("Key not found for certificate with serial " + cert.getSerialNumber());
        }
        if (key != null && (keyString = key.toString()).startsWith("SunPKCS11")) {
            provider = keyString.substring(0, keyString.indexOf(" "));
        }
        JceKeyTransEnvelopedRecipient recipient = new JceKeyTransEnvelopedRecipient(key);
        recipient.setProvider(provider);
        return info.getContent((Recipient)recipient);
    }

    public static X509Certificate getCertificateFromPEM(String pem) throws CertificateException, IOException {
        return CryptoUtils.parseCertificate((String)pem);
    }

    public static String getPEMFromCertificate(X509Certificate cert) throws IOException {
        StringWriter out = new StringWriter();
        JcaPEMWriter pemout = new JcaPEMWriter((Writer)out);
        pemout.writeObject((Object)cert);
        pemout.flush();
        return out.toString();
    }

    public static KeyPair getPrivateKey(byte[] key) throws IOException {
        KeyPair pair = null;
        PEMParser parser = new PEMParser((Reader)new InputStreamReader(new ByteArrayInputStream(key)));
        JcaPEMKeyConverter keyConverter = new JcaPEMKeyConverter().setProvider("BC");
        Object keyObject = parser.readObject();
        if (keyObject instanceof PEMKeyPair) {
            pair = keyConverter.getKeyPair((PEMKeyPair)keyObject);
        } else if (keyObject instanceof KeyPair) {
            pair = (KeyPair)keyObject;
        }
        parser.close();
        return pair;
    }

    public static PrivateKey getFirstKeyFormPKCS12(String filename, String password) throws KeyStoreException, FileNotFoundException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore store = KeyStore.getInstance("PKCS12");
        FileInputStream input = new FileInputStream(filename);
        store.load(input, password.toCharArray());
        Enumeration<String> enumAliases = store.aliases();
        while (enumAliases.hasMoreElements()) {
            String alias = enumAliases.nextElement();
            if (!store.isKeyEntry(alias)) continue;
            return (PrivateKey)store.getKey(alias, password.toCharArray());
        }
        return null;
    }

    public static X509Certificate getFirstCertificateWithKeyFormPKCS12(String filename, String password) throws KeyStoreException, FileNotFoundException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore store = KeyStore.getInstance("PKCS12");
        FileInputStream input = new FileInputStream(filename);
        store.load(input, password.toCharArray());
        Enumeration<String> enumAliases = store.aliases();
        while (enumAliases.hasMoreElements()) {
            String alias = enumAliases.nextElement();
            if (!store.isKeyEntry(alias)) continue;
            return (X509Certificate)store.getCertificate(alias);
        }
        return null;
    }
}

