/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.kdm;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.cvc.ECSignature;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.HexString;
import de.cardcontact.tlv.PrimitiveTLV;
import java.io.ByteArrayOutputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Signature;
import java.security.cert.CertPathBuilderException;
import opencard.core.OpenCardException;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkicard.ServiceRequestSmartCardHSMAction;
import org.openscdp.pkicard.kdm.IssueKeyDomainMembership;
import org.openscdp.pkicard.kdm.IssueKeyDomainMembershipContent;
import org.openscdp.pkidb.dao.CertificateDAO;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.action.ServiceRequestActionStates;
import org.openscdp.pkidm.holder.escrow.GroupSigner;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateContent;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueKeyDomainMembershipAction
extends ServiceRequestSmartCardHSMAction {
    public static final String ACTION = "action.kess.kdm.issue";
    private final Logger logger = LoggerFactory.getLogger(IssueKeyDomainMembershipAction.class);
    private IssueKeyDomainMembershipContent content;
    private GroupSigner groupSigner;

    public IssueKeyDomainMembershipAction(IssueKeyDomainMembership serviceRequest) {
        super(ACTION, serviceRequest);
        this.content = serviceRequest.getContent();
        String lastSeenAt = this.getGroupSigner().getBackend();
        if (lastSeenAt != null) {
            this.context = "@" + lastSeenAt;
        }
    }

    public boolean preFlightCheck() {
        if (this.content.groupSignerHolderId == null) {
            return false;
        }
        return this.content.getTokenPath() != null;
    }

    private GroupSigner getGroupSigner() {
        if (this.groupSigner == null) {
            try (Handle handle = PKIDMContext.getJDBI().open();){
                HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
                HolderDTO hdto = dao.getHolder(this.content.groupSignerHolderId);
                this.groupSigner = new GroupSigner(hdto);
            }
        }
        return this.groupSigner;
    }

    private byte[] getDeviceId() throws Exception {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
            Long deviceCertHolderId = holderDAO.determineId(this.content.getTokenPath(), 1);
            HolderDTO deviceCertHolder = holderDAO.getHolder(deviceCertHolderId);
            CertificateDAO certificateDAO = (CertificateDAO)handle.attach(CertificateDAO.class);
            CertificateDTO devAutCertDTO = certificateDAO.getCertificate(deviceCertHolder.getCertId());
            CardVerifiableCertificate devAut = new CardVerifiableCertificate(devAutCertDTO.getBytes());
            byte[] pk = devAut.getEncodedPublicKey();
            int len = pk.length - 1 >> 1;
            byte[] xbin = new byte[len];
            System.arraycopy(pk, 1, xbin, 0, len);
            byte[] byArray = xbin;
            return byArray;
        }
    }

    private void createCreateKeyDomainMembership(SmartCardHSMProvider provider, SmartCardHSMPrivateKey key) throws Exception {
        int tag = 84;
        ByteArrayOutputStream input = new ByteArrayOutputStream();
        input.write(tag);
        input.write(this.getDeviceId());
        Signature signature = Signature.getInstance("SHA256withECDSA", (Provider)provider);
        signature.initSign((PrivateKey)key);
        signature.update(input.toByteArray(), 0, input.size());
        byte[] signatureBytes = signature.sign();
        int keySize = key.getKeySize() + 7 >> 3;
        byte[] unwrappedSignature = ECSignature.unwrapSignature((byte[])signatureBytes, (int)keySize);
        PrimitiveTLV kdmTLV = new PrimitiveTLV(tag, unwrappedSignature);
        this.content.keyDomainMembership = HexString.hexifyByteArray((byte[])kdmTLV.getBytes());
        this.content.keyDomainUID = HexString.hexifyByteArray((byte[])this.getGroupSigner().getKeyDomainUID());
    }

    protected void postProcess() throws Exception {
        this.serviceRequest.setStatusInfo("Key Domain Membership issued");
        this.serviceRequest.setLifeCycle(7);
    }

    @Override
    public JSONActionResult execute() {
        SmartCardHSMPrivateKey key = (SmartCardHSMPrivateKey)this.getGroupSigner().getSigner().getKey();
        SmartCardHSMProvider provider = this.getGroupSigner().getSigner().getProvider();
        try {
            this.process(provider, key);
            this.updateState(ServiceRequestActionStates.COMPLETED);
            this.serviceRequest.commit(null);
        }
        catch (ServiceRequestActionException e) {
            this.logger.error("Action error", (Throwable)e);
            this.updateState(ServiceRequestActionStates.FAILED, e.getMessage());
            this.serviceRequest.commit((ServiceRequestStateContent)new ServiceRequestStateError(e.getMessage()));
        }
        return this.getStatus();
    }

    @Override
    public void execute(SmartCardHSMProvider provider) {
        SmartCardHSMPrivateKey key = (SmartCardHSMPrivateKey)this.getGroupSigner().getSigner().getKey(provider, true);
        this.process(provider, key);
    }

    protected void process(SmartCardHSMProvider provider, SmartCardHSMPrivateKey groupSignerKey) {
        try {
            if (!this.preFlightCheck()) {
                throw new ServiceRequestActionException("Precondition for service request not fulfilled");
            }
            if (groupSignerKey == null) {
                throw new ServiceRequestActionException("GroupSigner key not found");
            }
            if (!provider.getSmartCardHSMCardService().isSecureAuthenticatedSession()) {
                Object tokenPath;
                try {
                    tokenPath = provider.getSmartCardHSMCardService().getId();
                    tokenPath = (String)tokenPath + " ";
                }
                catch (CertPathBuilderException | OpenCardException e) {
                    tokenPath = "";
                }
                throw new ServiceRequestActionException("Token " + (String)tokenPath + "is not authenticated");
            }
            this.createCreateKeyDomainMembership(provider, groupSignerKey);
            this.postProcess();
        }
        catch (ServiceRequestActionException srae) {
            throw srae;
        }
        catch (Exception e) {
            throw new ServiceRequestActionException(e.getMessage(), (Throwable)e);
        }
    }
}

