/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.signer;

import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.util.ArrayList;
import opencard.core.OpenCardException;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.signer.SignerBase;
import org.openscdp.pkihsmsrv.HSMService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSMSigner
extends SignerBase {
    private final Logger logger = LoggerFactory.getLogger(HSMSigner.class);
    private String label;
    private SmartCardHSMProvider provider;

    public HSMSigner(SignerDTO dto) {
        super(dto);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public SmartCardHSMProvider getProvider() {
        return this.provider;
    }

    private Key getKey(byte[] keyId) {
        try {
            KeyStore keyStore = KeyStore.getInstance("SmartCardHSMKeyStore", (Provider)this.provider);
            keyStore.load(null, null);
            if (this.label == null) {
                SmartCardHSMCardService service = this.provider.getSmartCardHSMCardService();
                this.label = service.getAliasForKeyId(keyId);
                if (this.label == null) {
                    return null;
                }
            }
            Key key = keyStore.getKey(this.label, null);
            return key;
        }
        catch (Exception e) {
            throw new RuntimeException("get key failed with", e);
        }
    }

    public Key getKey(boolean usable) {
        int start;
        HSMService hsmService = PKIDMContext.getHSMService();
        ArrayList providers = hsmService.getProvider(this.dto.getKeyDomain());
        if (providers == null || providers.size() == 0) {
            return null;
        }
        int i = start = (int)((double)providers.size() * Math.random());
        do {
            Key key;
            if ((key = this.getKey((SmartCardHSMProvider)providers.get(i), usable)) != null) {
                return key;
            }
            if (++i < providers.size()) continue;
            i = 0;
        } while (i != start);
        return null;
    }

    public Key getKey(SmartCardHSMProvider provider, boolean usable) {
        this.provider = provider;
        Key key = this.getKey(this.dto.getKeyId());
        if (key != null) {
            if (!usable) {
                return key;
            }
            SmartCardHSMKey skey = (SmartCardHSMKey)key;
            try {
                if (skey.getUseCounter() != 0L && skey.getCardService().getPasswordStatus(null, 129) == CHVCardServiceWithControl.PasswordStatus.VERIFIED) {
                    return key;
                }
            }
            catch (OpenCardException e) {
                this.logger.error("Could not access token", (Throwable)e);
            }
        }
        return null;
    }

    public Key getKey() {
        return this.getKey(true);
    }

    public Status getStatus() {
        Key key = this.getKey(false);
        if (key == null) {
            return Status.OFFLINE;
        }
        SmartCardHSMKey skey = (SmartCardHSMKey)key;
        if (!skey.getCardService().isSecureAuthenticatedSession()) {
            return Status.ONLINE;
        }
        if (skey.getUseCounter() == 0L) {
            return Status.EXPIRED;
        }
        return Status.READY;
    }

    public static enum Status {
        OFFLINE,
        ONLINE,
        READY,
        CHANGED,
        EXPIRED;

    }
}

