/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.persistence;

import org.jdbi.v3.core.Handle;
import org.openscdp.pkidb.dao.CertificateDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.persistence.Certificates;

public class DBCertificates
implements Certificates {
    private CertificateDAO certDAO;

    public DBCertificates(Handle handle) {
        this.certDAO = (CertificateDAO)handle.attach(CertificateDAO.class);
    }

    @Override
    public CertificateDTO newCertificate(CertificateDTO certificate) {
        this.certDAO.create(certificate);
        return certificate;
    }

    @Override
    public CertificateDTO getCertificate(HolderDTO holder, String serial, int linkDir) {
        return this.certDAO.getCertificateBySerial(holder.getId(), serial, linkDir);
    }

    @Override
    public CertificateDTO getCurrentCertificate(HolderDTO holder) {
        if (holder.getCertId() == null) {
            return null;
        }
        return this.certDAO.getCertificate(holder.getCertId());
    }
}

