/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.validators;

import com.google.common.net.InetAddresses;
import de.dfncert.validators.CIDRUtils;
import java.net.InetAddress;
import java.util.regex.Pattern;

public class IPAddress {
    private static final String IPv4_STRING = "((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)";
    private static final Pattern IPv4_REGEXP = Pattern.compile("^((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)$");
    private static final Pattern IPv4_REGEXP_RESERVED = Pattern.compile("^(0|10|127|100\\.(6[4-9]|[789][0-9]|1[01][0-9]|12[0-7])|169\\.254|172\\.(1[6-9]|2\\d|3[01])192\\.0\\.0|192\\.0\\.2|192\\.88\\.99|192\\.168|198\\.1[89]|198\\.51\\.100|203\\.0\\.113|(22[4-9]|23[0-9])|(24[0-9]|25[0-5])|255\\.255\\.255\\.255|)\\..+");
    private static final String H = "[0-9a-fA-F]{1,4}";
    private static final String H4 = String.format("(%s(:%s)?|%s)", "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", "((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)");
    private static final Pattern IPv6_REGEXP = Pattern.compile(String.format("^(%s:){6}(%s:%s|%s)|::(%s:){0,5}%s|%s::(%s:){0,4}%s|%s(:%s){0,1}::(%s:){0,3}%s|%s(:%s){0,2}::(%s:){0,2}%s|%s(:%s){0,3}::(%s:){0,1}%s|%s(:%s){0,4}::%s|%s(:%s){0,5}::%s|%s(:%s){0,6}::$", "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", "((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)", "[0-9a-fA-F]{1,4}", H4, "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", H4, "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", H4, "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", H4, "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", H4, "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", H4, "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}", "[0-9a-fA-F]{1,4}"));
    private static final Pattern IPv6_REGEXP_GLOBAL_UNICAST = Pattern.compile("^[23].+");
    private static final CIDRUtils[] RESERVED_CIDRS = new CIDRUtils[]{new CIDRUtils("0.0.0.0/8"), new CIDRUtils("0.0.0.0/32"), new CIDRUtils("10.0.0.0/8"), new CIDRUtils("100.64.0.0/10"), new CIDRUtils("127.0.0.0/8"), new CIDRUtils("169.254.0.0/16"), new CIDRUtils("172.16.0.0/12"), new CIDRUtils("192.0.0.0/24"), new CIDRUtils("192.0.0.0/29"), new CIDRUtils("192.0.0.8/32"), new CIDRUtils("192.0.0.9/32"), new CIDRUtils("192.0.0.10/32"), new CIDRUtils("192.0.0.170/32"), new CIDRUtils("192.0.0.171/32"), new CIDRUtils("192.0.2.0/24"), new CIDRUtils("192.31.196.0/24"), new CIDRUtils("192.52.193.0/24"), new CIDRUtils("192.88.99.0/24"), new CIDRUtils("192.168.0.0/16"), new CIDRUtils("192.175.48.0/24"), new CIDRUtils("198.18.0.0/15"), new CIDRUtils("198.51.100.0/24"), new CIDRUtils("203.0.113.0/24"), new CIDRUtils("240.0.0.0/4"), new CIDRUtils("255.255.255.255/32"), new CIDRUtils("::1/128"), new CIDRUtils("::/128"), new CIDRUtils("::ffff:0:0/96"), new CIDRUtils("64:ff9b::/96"), new CIDRUtils("64:ff9b:1::/48"), new CIDRUtils("100::/64"), new CIDRUtils("2001::/23"), new CIDRUtils("2001::/32"), new CIDRUtils("2001:1::1/128"), new CIDRUtils("2001:1::2/128"), new CIDRUtils("2001:2::/48"), new CIDRUtils("2001:3::/32"), new CIDRUtils("2001:4:112::/48"), new CIDRUtils("2001:10::/28"), new CIDRUtils("2001:20::/28"), new CIDRUtils("2001:db8::/32"), new CIDRUtils("2002::/16"), new CIDRUtils("2620:4f:8000::/48"), new CIDRUtils("fc00::/7"), new CIDRUtils("fe80::/10")};

    public static boolean isIP(String address) {
        return IPAddress.isIPv4(address) || IPAddress.isIPv6(address);
    }

    public static boolean isIPv4(String address) {
        return IPv4_REGEXP.matcher(address).matches();
    }

    public static boolean isIPv6(String address) {
        return IPv6_REGEXP.matcher(address).matches();
    }

    public static boolean isReservedIP(String address) {
        if (!IPAddress.isIP(address)) {
            return false;
        }
        if (IPAddress.isIPv4(address) && IPv4_REGEXP_RESERVED.matcher(address).matches() || IPAddress.isIPv6(address) && !IPv6_REGEXP_GLOBAL_UNICAST.matcher(address).matches()) {
            return true;
        }
        for (CIDRUtils cidr : RESERVED_CIDRS) {
            if (!cidr.isInRange(address)) continue;
            return true;
        }
        return false;
    }

    public static String normalize(String address) {
        InetAddress inetAddress = InetAddresses.forString((String)address);
        return InetAddresses.toAddrString((InetAddress)inetAddress);
    }
}

