/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.utils;

import de.dfncert.datatypes.EmailAddress;
import de.dfncert.utils.crypto.DFNStyle;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.IDN;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.util.encoders.Hex;

public class UtilsFormat {
    private static final HashMap<String, String> months;
    private static final Pattern patternLT;
    private static final Pattern patternGT;
    private static final Pattern patternAMP;
    private static final SimpleDateFormat isoFormat;
    private static final SimpleDateFormat isoFormatRetainTimezone;
    private static final SimpleDateFormat opencaFormat;
    private static final SimpleDateFormat opencaNotAfterFormat;
    private static final SimpleDateFormat opencaShortNotAfterFormat;

    private UtilsFormat() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToOpenCA(Date input) {
        if (input == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = opencaFormat;
        synchronized (simpleDateFormat) {
            String result = opencaFormat.format(input);
            if (result.charAt(8) == '0') {
                StringBuilder tmp = new StringBuilder(result);
                tmp.setCharAt(8, ' ');
                result = tmp.toString();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToOpenCANotAfter(Date input) {
        if (input == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = opencaNotAfterFormat;
        synchronized (simpleDateFormat) {
            return opencaNotAfterFormat.format(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToOpenCAShortNotAfter(Date input) {
        if (input == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = opencaShortNotAfterFormat;
        synchronized (simpleDateFormat) {
            return opencaShortNotAfterFormat.format(input);
        }
    }

    public static String getOpenSSLModulus(PublicKey key) {
        RSAPublicKey pkey = (RSAPublicKey)key;
        byte[] mod = pkey.getModulus().toByteArray();
        StringBuilder result = new StringBuilder(1024);
        result.append("Modulus (");
        result.append(pkey.getModulus().bitLength());
        result.append(" bit):");
        for (int i = 0; i < mod.length; ++i) {
            if (i % 15 == 0) {
                result.append("\n    ");
            }
            result.append(String.format("%02x", mod[i]));
            if (i >= mod.length - 1) continue;
            result.append(":");
        }
        result.append("\nExponent: ");
        result.append(pkey.getPublicExponent().toString());
        result.append(String.format(" (0x%x)", pkey.getPublicExponent().intValue()));
        result.append("\n");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date isoDateToDate(String input) throws ParseException {
        if (input == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = isoFormat;
        synchronized (simpleDateFormat) {
            return isoFormat.parse(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToIsoDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = isoFormat;
        synchronized (simpleDateFormat) {
            return isoFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToIsoDateRetainTimezone(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = isoFormatRetainTimezone;
        synchronized (simpleDateFormat) {
            return isoFormatRetainTimezone.format(date);
        }
    }

    public static String opencaNotAfterDateToISO(String input) {
        if (input.length() < 14) {
            return "";
        }
        try {
            return UtilsFormat.dateToIsoDate(UtilsFormat.opencaNotAfterDateToDate(input));
        }
        catch (ParseException ex) {
            return "";
        }
    }

    public static String opencaDateToISO(String input) {
        if (input == null || input.length() < 24) {
            return "";
        }
        try {
            return UtilsFormat.dateToIsoDate(UtilsFormat.opencaDateToDate(input));
        }
        catch (ParseException ex) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date opencaDateToDate(String input) throws ParseException {
        if (input == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = opencaFormat;
        synchronized (simpleDateFormat) {
            return opencaFormat.parse(input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date opencaNotAfterDateToDate(String input) throws ParseException {
        if (input == null) {
            return null;
        }
        if (input.length() == 12) {
            SimpleDateFormat simpleDateFormat = opencaShortNotAfterFormat;
            synchronized (simpleDateFormat) {
                return opencaShortNotAfterFormat.parse(input);
            }
        }
        SimpleDateFormat simpleDateFormat = opencaNotAfterFormat;
        synchronized (simpleDateFormat) {
            return opencaNotAfterFormat.parse(input);
        }
    }

    public static String quoteXML(String input) {
        input = patternLT.matcher(input).replaceAll("&lt;");
        input = patternGT.matcher(input).replaceAll("&gt;");
        input = patternAMP.matcher(input).replaceAll("&amp;");
        return input;
    }

    public static String convertDiacritics(String input) {
        input = input.replaceAll("\u00e4", "ae");
        input = input.replaceAll("\u00c4", "Ae");
        input = input.replaceAll("\u00f6", "oe");
        input = input.replaceAll("\u00d6", "Oe");
        input = input.replaceAll("\u00fc", "ue");
        input = input.replaceAll("\u00dc", "Ue");
        input = input.replaceAll("\u00df", "ss");
        input = StringUtils.stripAccents((String)input);
        return input;
    }

    public static boolean isValidPLabel(String label) {
        if (label.contains(".")) {
            return false;
        }
        return !IDN.toUnicode(label, 2).equals(label);
    }

    public static boolean isValidDomain(String domain) {
        if (!domain.matches("^(?!\\.).+(?<!\\.)$")) {
            return false;
        }
        if (domain.startsWith("*.")) {
            domain = domain.substring(2);
        }
        for (String label : domain.split("\\.")) {
            if (Patterns.NON_RESERVED_LDH_LABEL.matches(label) || UtilsFormat.isValidPLabel(label)) continue;
            return false;
        }
        return true;
    }

    public static String reverseDN(byte[] dn) {
        X500Principal x500 = new X500Principal(dn);
        return x500.getName("RFC2253", DFNStyle.getOidMap());
    }

    public static synchronized String sha1(File file) throws Exception {
        try (FileInputStream in = null;){
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            in = new FileInputStream(file);
            int byt = in.read();
            while (byt > -1) {
                digest.update((byte)byt);
                byt = in.read();
            }
            String string = new String(Hex.encode((byte[])digest.digest()));
            return string;
        }
    }

    public static String sha1(byte[] input) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return new String(Hex.encode((byte[])digest.digest(input)));
    }

    public static String sha1(byte[] input, String bytesSeparator, boolean upperCase) {
        String hash = UtilsFormat.sha1(input);
        hash = upperCase ? hash.toUpperCase() : hash.toLowerCase();
        if (bytesSeparator != null) {
            int len = hash.length();
            StringBuilder result = new StringBuilder(len + len / 2);
            for (int i = 0; i < len; i += 2) {
                result.append(hash.substring(i, i + 2));
                if (i >= len - 2) continue;
                result.append(bytesSeparator);
            }
            return result.toString();
        }
        return hash;
    }

    public static String sha256(byte[] input) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return new String(Hex.encode((byte[])digest.digest(input)));
    }

    public static String join(Object[] strings, String delimiter) {
        if (strings == null) {
            return null;
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            out.append(strings[i]);
            if (i >= strings.length - 1) continue;
            out.append(delimiter);
        }
        return out.toString();
    }

    public static String join(Collection strings, String delimiter) {
        if (strings == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        Iterator iter = strings.iterator();
        while (iter.hasNext()) {
            result.append(iter.next());
            if (!iter.hasNext()) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static ArrayList<String> splitOpenCAConfigValue(String input) {
        StringTokenizer tokens = new StringTokenizer(input, "\"");
        ArrayList<String> result = new ArrayList<String>();
        boolean odd = true;
        while (tokens.hasMoreElements()) {
            String next = tokens.nextToken();
            if (odd) {
                result.add(next);
            }
            odd = !odd;
        }
        return result;
    }

    public static String getSimilarToDN(String dn, boolean bDNWithoutEmail) {
        X500Name name = new X500Name((X500NameStyle)DFNStyle.INSTANCE, dn);
        StringBuilder result = new StringBuilder();
        for (RDN rdn : name.getRDNs()) {
            String value = IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue()).trim().toUpperCase();
            String attr = DFNStyle.INSTANCE.oidToDisplayName(rdn.getFirst().getType());
            if (bDNWithoutEmail && attr.equals("emailAddress=")) continue;
            if (result != null && result.length() > 0) {
                result.append(",");
            }
            result.append(attr.toUpperCase());
            result.append("=");
            result.append("[[:space:]]*");
            value = value.replaceAll("([()\\\\+\\[\\]_|*%])", "\\\\$1");
            value = value.replaceAll("[ ]+", "[[:space:]]+");
            result.append(value);
            result.append("[[:space:]]*");
        }
        return result.toString();
    }

    @Deprecated
    public static String getOIDString(ASN1ObjectIdentifier oid) {
        String str;
        if (oid == null) {
            return null;
        }
        HashMap<String, String> oidMap = DFNStyle.getOidMap();
        if (oidMap.containsKey(str = oid.toString())) {
            return oidMap.get(str);
        }
        return str;
    }

    public static Date addDaysToDate(Date date, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static String quoteTexCharacters(String input) {
        input = input.replaceAll("([#$&~_^%{}\\\\])", "\\\\$1");
        input = input.replaceAll("\\\\([~^])", "\\\\$1{}");
        input = input.replaceAll("\\\\\\\\", "\\\\textbackslash{}");
        return input;
    }

    public static String replace(String subject, HashMap<String, String> replacements) {
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            if (subject == null || entry.getValue() == null) continue;
            subject = subject.replace(entry.getKey(), entry.getValue());
        }
        return subject;
    }

    public static String shorten(String input, int characters) {
        if (characters < 4) {
            throw new IllegalArgumentException("Der String kann auf minimal 4 Zeichen verk\u00fcrzt werden.");
        }
        if (input.length() <= characters) {
            return input;
        }
        return input.substring(0, characters - 4) + " ...";
    }

    public static HashMap<String, String> parseConfFile(File file, String ... keys) throws IOException {
        HashSet<String> keySet = new HashSet<String>();
        keySet.addAll(Arrays.asList(keys));
        HashMap<String, String> result = new HashMap<String, String>();
        BufferedReader conf = new BufferedReader(new FileReader(file));
        String line = conf.readLine();
        while (line != null) {
            String key;
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
                line = conf.readLine();
                continue;
            }
            int pos = line.indexOf(" ");
            if (pos == -1) {
                pos = line.indexOf("\t");
            }
            if (pos > -1 && keySet.contains(key = line.substring(0, pos))) {
                int indexComment;
                String value = line.substring(pos).trim();
                if (value.startsWith("\"")) {
                    value = value.substring(1);
                }
                if (value.endsWith("\"")) {
                    value = value.substring(0, value.length() - 1);
                }
                if ((indexComment = value.indexOf("#")) > 0) {
                    value = value.substring(0, indexComment);
                    value = value.trim();
                }
                result.put(key, value);
            }
            line = conf.readLine();
        }
        return result;
    }

    static {
        patternLT = Pattern.compile("<");
        patternGT = Pattern.compile(">");
        patternAMP = Pattern.compile("&");
        isoFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        isoFormatRetainTimezone = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        opencaFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy zzz", Locale.ENGLISH);
        opencaNotAfterFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        opencaShortNotAfterFormat = new SimpleDateFormat("yyMMddHHmmss");
        months = new HashMap();
        months.put("Jan", "01");
        months.put("Feb", "02");
        months.put("Mar", "03");
        months.put("Apr", "04");
        months.put("May", "05");
        months.put("Jun", "06");
        months.put("Jul", "07");
        months.put("Aug", "08");
        months.put("Sep", "09");
        months.put("Oct", "10");
        months.put("Nov", "11");
        months.put("Dec", "12");
        opencaFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        opencaNotAfterFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        opencaShortNotAfterFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        isoFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public static enum Patterns {
        CN("^[\\w'()+,./:=? -]+$"),
        SHA1("^[0-9a-fA-F]{40}$"),
        GUID("^[0-9a-fA-F]+$"),
        LATIN1("^[a-zA-Z0-9\\xA0-\\xFF().-]*$"),
        LATIN1_FULL("^[a-zA-Z0-9\\xA0-\\xFF()./: &_!\"\u00a7$%=?,;@+*#\\\\'-]*$"),
        ALPHA_NUM_DOT_HYPHEN("^[a-zA-Z0-9.-]+$"),
        ALPHA_NUM_DOT_HYPHEN_COLON_SLASH("^[a-zA-Z0-9.:/-]+$"),
        TEXT("^[a-zA-Z0-9() ,'.:/-]*[a-zA-Z0-9][a-zA-Z0-9() ,'.:/-]*$"),
        TEXT_WITH_AT("^[a-zA-Z0-9@() ,'.:/-]*[a-zA-Z0-9][a-zA-Z0-9@() ,'.:/-]*$"),
        GRP_TEXT_WITH_AT("^(GRP:|GRP -)[a-zA-Z0-9@() ,'.:/-]*[a-zA-Z0-9][a-zA-Z0-9@() ,'.:/-]*$"),
        PN_TEXT_WITH_AT("^(PN:|PN -)[a-zA-Z0-9@() ,'.:/-]*[a-zA-Z0-9][a-zA-Z0-9@() ,'.:/-]*$"),
        ROBOT_TEXT_WITH_AT("^(Robot:|Robot-)[a-zA-Z0-9@() ,'.:/-]*[a-zA-Z0-9][a-zA-Z0-9@() ,'.:/-]*$"),
        EMAIL,
        DN("^([a-zA-Z0-9_=@() ,'.:/-]|\\\\[,+ ])*$"),
        DN_WITH_WILDCARD("^([a-zA-Z0-9_=@()\\* ,'.:/-]|\\\\[,+ ])*$"),
        HOSTNAME("[0-9a-zA-Z-]+"),
        DOMAIN("([0-9a-zA-Z](-*[0-9a-zA-Z])*\\.)+[0-9a-zA-Z](-*[0-9a-zA-Z])*"),
        DOMAIN_OR_WILDCARDDOMAIN("^(\\*\\.)?([0-9a-zA-Z](-*[0-9a-zA-Z])*\\.)+[0-9a-zA-Z](-*[0-9a-zA-Z])*"),
        NON_RESERVED_LDH_LABEL("^(?!-)(?!..--)[0-9a-zA-Z-]{1,63}(?<!-)$");

        Pattern regexp;

        private Patterns(String re) {
            this.regexp = Pattern.compile(re);
        }

        private Patterns() {
        }

        public boolean matches(String input) {
            if (input == null) {
                input = "";
            }
            if (this == EMAIL) {
                return EmailAddress.validate(input);
            }
            return this.regexp.matcher(input).matches();
        }
    }
}

