/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.datatypes;

import de.dfncert.errors.ProgrammingError;
import de.dfncert.utils.UtilsFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import java.util.TreeMap;

public class DataColumn {
    private TreeMap<String, String> values = new TreeMap();
    private String body;
    private String signature;

    public static DataColumn fromString(String input) {
        DataColumn inst = new DataColumn();
        StringBuilder bodyBuilder = new StringBuilder();
        StringBuilder signatureBuilder = new StringBuilder();
        BufferedReader in = new BufferedReader(new StringReader(input));
        try {
            String line = in.readLine();
            while (line != null && !line.startsWith("-----END HEADER")) {
                int eqPos = line.indexOf("=");
                if (eqPos > -1) {
                    String key = line.substring(0, eqPos).trim();
                    String value = line.substring(eqPos + 1).trim();
                    if (value.isEmpty()) {
                        value = null;
                    }
                    inst.values.put(key, value);
                }
                line = in.readLine();
            }
            line = in.readLine();
            while (line != null && !line.startsWith("-----BEGIN PKCS7")) {
                bodyBuilder.append(line);
                bodyBuilder.append("\n");
                line = in.readLine();
            }
            while (line != null) {
                signatureBuilder.append(line);
                signatureBuilder.append("\n");
                line = in.readLine();
            }
            inst.body = bodyBuilder.toString().trim();
            inst.signature = signatureBuilder.length() == 0 ? null : signatureBuilder.toString().trim();
            in.close();
            return inst;
        }
        catch (IOException ex) {
            throw new ProgrammingError("Der (buffered) Stringreader hat sich verschluckt.", ex);
        }
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getBody() {
        if (this.body != null) {
            return this.body.toString();
        }
        return null;
    }

    public void setBody(String body) {
        this.body = body.trim();
    }

    public String getBodyValue(String key) throws IOException {
        BufferedReader lines = new BufferedReader(new StringReader(this.body));
        String line = lines.readLine();
        while (line != null) {
            if (line.startsWith(key)) {
                int index = line.indexOf("=");
                return line.substring(index + 1).trim();
            }
            line = lines.readLine();
        }
        return null;
    }

    public void setBodyValue(String key, String value) throws IOException {
        String newBody = "";
        BufferedReader lines = new BufferedReader(new StringReader(this.body));
        String line = lines.readLine();
        while (line != null) {
            if (line.startsWith(key)) {
                int index = line.indexOf("=");
                String oldValue = line.substring(index + 1).trim();
                line = value != null && !value.isEmpty() ? line.replace(oldValue, value) : line.replace(oldValue, " ");
            }
            newBody = newBody + line + "\n";
            line = lines.readLine();
        }
        this.setBody(newBody);
    }

    public String getString(String key) {
        return this.values.get(key);
    }

    public String[] getStringArray(String key) {
        String str = this.values.get(key);
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return null;
        }
        return str.split(", *");
    }

    public Date getDate(String key) throws ParseException {
        String value = this.values.get(key);
        if (value == null || "".equals(value)) {
            return null;
        }
        return UtilsFormat.opencaDateToDate(value);
    }

    public Integer getInt(String key) {
        String value = this.values.get(key);
        if (value == null || "".equals(value)) {
            return null;
        }
        return Integer.parseInt(this.values.get(key));
    }

    public long getLong(String key) {
        return Long.parseLong(this.values.get(key));
    }

    public boolean getBool(String key) {
        if (key == null) {
            return false;
        }
        return "on".equals(this.values.get(key));
    }

    public void put(String key, String value) {
        if (value != null) {
            this.values.put(key, value);
        } else {
            this.values.remove(key);
        }
    }

    public void put(String key, String[] value) {
        if (value == null) {
            this.values.remove(key);
            return;
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            out.append(value[i]);
            if (i >= value.length - 1) continue;
            out.append(",");
        }
        this.put(key, out.toString());
    }

    public void put(String key, Date date) {
        if (date != null) {
            this.put(key, UtilsFormat.dateToOpenCA(date));
        }
    }

    public void put(String key, Integer value) {
        if (value == null) {
            this.values.remove(key);
            return;
        }
        this.put(key, Integer.toString(value));
    }

    public void put(String key, int integer) {
        this.put(key, Integer.toString(integer));
    }

    public void put(String key, long longest) {
        this.put(key, Long.toString(longest));
    }

    public void put(String key, BigInteger bigInt) {
        this.put(key, bigInt.toString());
    }

    public void remove(String key) {
        this.values.remove(key);
    }

    public boolean containsKey(String key) {
        return this.values.containsKey(key);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("-----BEGIN HEADER-----");
        out.append("\n");
        for (String key : this.values.keySet()) {
            String value = this.values.get(key);
            out.append(key);
            out.append(" = ");
            out.append(value != null ? value : "");
            out.append("\n");
        }
        out.append("-----END HEADER-----");
        out.append("\r");
        if (this.body != null) {
            out.append("\n");
            out.append(this.body.toString());
        }
        if (this.signature != null) {
            if (!this.body.endsWith("\n")) {
                out.append("\n");
            }
            out.append(this.signature);
        }
        return out.toString();
    }
}

