/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.ParseBuffer;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.iso.fs.CardFilePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardHSMCipher
extends CipherSpi {
    private static final Logger log = LoggerFactory.getLogger(SmartCardHSMCipher.class);
    private SmartCardHSMCardService schsm;
    private int selectedMode;
    private String algorithm;
    private ByteArrayOutputStream input;
    private SmartCardHSMKey key;
    private SmartCardHSMProvider provider;

    public SmartCardHSMCipher(SmartCardHSMProvider provider, String algorithm) {
        this.provider = provider;
        this.schsm = provider.getSmartCardHSMCardService();
        this.algorithm = algorithm;
        if (!provider.isVerified()) {
            throw new ProviderException("Login required.");
        }
    }

    protected byte[] decipher() {
        byte[] result;
        byte algorithmID;
        switch (this.algorithm) {
            case "RSA/None/PKCS1Padding": 
            case "RSA/ECB/PKCS1Padding": {
                algorithmID = 34;
                break;
            }
            case "RSA/ECB/OAEPWithSHA-1AndMGF1Padding": {
                algorithmID = 35;
                break;
            }
            default: {
                algorithmID = 33;
            }
        }
        try {
            result = this.schsm.decipher(this.key, this.input.toByteArray(), algorithmID);
        }
        catch (CardTerminalException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (CardServiceException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        return result;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (input != null) {
            if (this.input.size() + inputLen > this.key.getKeySize() / 8) {
                throw new ProviderException("Input Data exceeds the lenght of the modulus");
            }
            this.input.write(input, inputOffset, inputLen);
        }
        byte[] res = this.decipher();
        this.selectedMode = -1;
        this.input.reset();
        this.input = null;
        return res;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] res = this.engineDoFinal(input, inputOffset, inputLen);
        if (res.length > output.length - outputOffset) {
            throw new ShortBufferException("The output buffer is too short");
        }
        System.arraycopy(res, 0, output, outputOffset, res.length);
        return res.length;
    }

    @Override
    protected int engineGetBlockSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected byte[] engineGetIV() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int engineGetOutputSize(int arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int mode, Key key, SecureRandom rnd) throws InvalidKeyException {
        if (mode != 2 && mode != 3 && mode != 4) {
            throw new UnsupportedOperationException("Only Decryption, Wrap and Unwrap mode are supported");
        }
        this.selectedMode = mode;
        if (mode != 3 && mode != 4) {
            if (!(key instanceof SmartCardHSMKey)) {
                throw new InvalidKeyException("Key must be type of SmartCardHSMKey");
            }
            this.key = (SmartCardHSMKey)key;
            this.input = new ByteArrayOutputStream();
        }
    }

    @Override
    protected void engineInit(int arg0, Key arg1, AlgorithmParameterSpec arg2, SecureRandom arg3) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineInit(int arg0, Key arg1, AlgorithmParameters arg2, SecureRandom arg3) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineSetMode(String arg0) throws NoSuchAlgorithmException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineSetPadding(String arg0) throws NoSuchPaddingException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (this.input.size() + inputLen > this.key.getKeySize()) {
            throw new ProviderException("Input Data exceeds the lenght of the modulus");
        }
        this.input.write(input, inputOffset, inputLen);
        return null;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        this.engineUpdate(input, inputOffset, inputLen);
        return 0;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof SmartCardHSMKey) {
            return ((SmartCardHSMKey)key).getKeySize();
        }
        throw new InvalidKeyException("Key must be type of SmartCardHSMKey");
    }

    private void buildCertChain(ConstructedTLV seq, byte[] certBinary) {
        try {
            ParseBuffer pb = new ParseBuffer(certBinary);
            ConstructedTLV tlv = new ConstructedTLV(48);
            tlv.parseList(pb);
            for (int i = 0; i < tlv.getElements(); ++i) {
                seq.add(tlv.get(i));
            }
            if (certBinary[0] == 103 && tlv.getElements() == 1) {
                CardVerifiableCertificate[] chain = this.schsm.getCertificateChain();
                for (int i = 0; i < chain.length; ++i) {
                    seq.add((TLV)chain[i].getCVCertificate());
                }
            }
        }
        catch (Exception e) {
            log.error("Certificate EF does not contain valid TLV encoding", (Throwable)e);
            new ProviderException("Certificate EF does not contain valid TLV encoding", e);
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException {
        ConstructedTLV sequence;
        byte[] prkdBinary;
        byte[] wrappedKeyBinary;
        if (this.selectedMode != 3) {
            throw new IllegalStateException("Cipher is not in wrap mode");
        }
        if (!(key instanceof SmartCardHSMKey)) {
            throw new InvalidKeyException("Key must be type of SmartCardHSMKey");
        }
        byte[] certBinary = null;
        SmartCardHSMKey hsmKey = (SmartCardHSMKey)key;
        try {
            wrappedKeyBinary = this.schsm.wrapKey(hsmKey.getKeyRef());
            CardFilePath path = new CardFilePath(new byte[]{-60, hsmKey.getKeyRef()});
            prkdBinary = this.schsm.read(path, 0, -1);
            path = new CardFilePath(new byte[]{-50, hsmKey.getKeyRef()});
            if (this.schsm.exists(path)) {
                certBinary = this.schsm.read(path, 0, -1);
            }
        }
        catch (CardServiceException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (CardTerminalException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        try {
            sequence = new ConstructedTLV(48);
            PrimitiveTLV wrappedKey = new PrimitiveTLV(4, wrappedKeyBinary);
            PrimitiveTLV prkd = new PrimitiveTLV(prkdBinary);
            sequence.add((TLV)wrappedKey);
            sequence.add((TLV)prkd);
            if (certBinary != null) {
                this.buildCertChain(sequence, certBinary);
            }
        }
        catch (TLVEncodingException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        return sequence.getBytes();
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) {
        if (this.selectedMode != 4) {
            throw new IllegalStateException("Cipher is not in unwrap mode");
        }
        try {
            ConstructedTLV sequence = new ConstructedTLV(wrappedKey);
            byte kid = this.schsm.determineFreeKeyId();
            this.schsm.unwrapKey(kid, sequence.get(0).getValue());
            CardFilePath path = new CardFilePath(new byte[]{-60, kid});
            this.schsm.write(path, 0, sequence.get(1).getBytes());
            path = new CardFilePath(new byte[]{-50, kid});
            if (this.schsm.exists(path)) {
                this.schsm.delete(path);
            }
            if (sequence.getElements() > 2) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                for (int i = 2; i < sequence.getElements(); ++i) {
                    bs.writeBytes(sequence.get(i).getBytes());
                }
                this.schsm.write(path, 0, bs.toByteArray());
            }
            return this.schsm.addKey(kid);
        }
        catch (CardTerminalException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (CardServiceException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (TLVEncodingException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
    }
}

