/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.stream.Stream;
import org.jdbi.v3.sqlobject.DefaultMethodHandler;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizingAnnotation;

class DefaultMethodHandlerFactory
implements HandlerFactory {
    DefaultMethodHandlerFactory() {
    }

    @Override
    public Optional<Handler> buildHandler(Class<?> sqlObjectType, Method method) {
        if (!method.isDefault()) {
            return Optional.empty();
        }
        Stream.of(method.getAnnotations()).map(Annotation::annotationType).filter(type -> type.isAnnotationPresent(SqlStatementCustomizingAnnotation.class)).findFirst().ifPresent(type -> {
            throw new IllegalStateException(String.format("Default method %s.%s has @%s annotation. Statement customizing annotations don't work on default methods.", sqlObjectType.getSimpleName(), method.getName(), type.getSimpleName()));
        });
        for (Parameter parameter : method.getParameters()) {
            Stream.of(parameter.getAnnotations()).map(Annotation::annotationType).filter(type -> type.isAnnotationPresent(SqlStatementCustomizingAnnotation.class)).findFirst().ifPresent(type -> {
                throw new IllegalStateException(String.format("Default method %s.%s parameter %s has @%s annotation. Statement customizing annotations don't work on default methods.", sqlObjectType.getSimpleName(), method.getName(), parameter.getName(), type.getSimpleName()));
            });
        }
        return Optional.of(new DefaultMethodHandler(method));
    }
}

