/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.escrow.receive;

import de.cardcontact.tlv.HexString;
import de.cardcontact.tlv.TLVEncodingException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkicard.escrow.SmartCardHSMCertificateChainTLV;
import org.openscdp.pkicard.escrow.receive.GenerateExchangeKeyAction;
import org.openscdp.pkicard.escrow.receive.ReceiveKeyFromEscrowAction;
import org.openscdp.pkicard.escrow.receive.ReceiveKeyFromEscrowContent;
import org.openscdp.pkicard.escrow.receive.RewrapKeyForReceiverAction;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.RoleDAO;
import org.openscdp.pkidb.dao.TokenDAO;
import org.openscdp.pkidb.dto.AssignedRoleDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidb.dto.TokenDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.action.ServiceRequestSaveAction;
import org.openscdp.pkidm.holder.escrow.KeyEscrow;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestBase;
import org.openscdp.pkidm.subject.TrustCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveKeyFromEscrowSharedServiceRequest
extends ServiceRequestBase {
    public static final String PROCESS = "ReceiveKeyFromEscrow";
    private final Logger logger = LoggerFactory.getLogger(ReceiveKeyFromEscrowSharedServiceRequest.class);
    private TrustCenter trustCenter;
    private KeyEscrow keyEscrowHolder;
    private ReceiveKeyFromEscrowContent content;

    public ReceiveKeyFromEscrowSharedServiceRequest(ServiceRequestDTO dto) {
        super(dto);
    }

    public TrustCenter getTrustCenter() {
        if (this.trustCenter == null) {
            Long tId = this.getRecipientId();
            this.trustCenter = (TrustCenter)PKIDMContext.getSubjectFactoryRegistry().getById(tId, TrustCenter.class);
        }
        return this.trustCenter;
    }

    public KeyEscrow getKeyEscrowHolder() {
        if (this.keyEscrowHolder == null) {
            try (Handle handle = PKIDMContext.getJDBI().open();){
                HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
                HolderDTO holder = dao.getHolder(this.getContent().keyEscrowHolderId);
                this.keyEscrowHolder = new KeyEscrow(holder);
            }
        }
        return this.keyEscrowHolder;
    }

    public boolean hasRole(Long roleId) {
        AssignedRoleDTO roleAssignment;
        try (Handle handle = PKIDMContext.getJDBI().open();){
            RoleDAO dao = (RoleDAO)handle.attach(RoleDAO.class);
            roleAssignment = dao.getAssignedRole(this.userId.longValue(), roleId.longValue());
        }
        return roleAssignment != null;
    }

    public boolean isCAOfficer() {
        return this.hasRole(this.getTrustCenter().getCaRoleId());
    }

    public void assignToCAOfficer() {
        this.setRoleId(this.getTrustCenter().getCaRoleId());
    }

    public ReceiveKeyFromEscrowContent getContent() {
        if (this.content == null) {
            this.content = (ReceiveKeyFromEscrowContent)this.getContentView(ReceiveKeyFromEscrowContent.class);
        }
        return this.content;
    }

    public String getBackendReceiverConnectedTo() {
        return this.getBackendConnectedTo(this.getContent().getTokenPath());
    }

    public String getBackendEscrowConnectedTo() {
        try {
            return this.getBackendConnectedTo(this.getKeyEscrowHolder().getTokenPath());
        }
        catch (Exception e) {
            this.logger.error("Failed to deterine the escrow token path", (Throwable)e);
            throw new ServiceRequestActionException("Failed to deterine the escrow token path", (Throwable)e);
        }
    }

    public String getBackendConnectedTo(String tokenPath) {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            TokenDAO dao = (TokenDAO)handle.attach(TokenDAO.class);
            TokenDTO dto = dao.getToken(tokenPath);
            if (dto.getOnline() == 0L) {
                String string = null;
                return string;
            }
            String string = dto.getLastSeenAt();
            return string;
        }
    }

    public ServiceRequestAction getActionFor(JSONAction action) {
        if (action.action.equals("action.save")) {
            return new ServiceRequestSaveAction((ServiceRequest)this);
        }
        if (action.action.equals("action.kess.generateexchangekey")) {
            return new GenerateExchangeKeyAction(this);
        }
        if (action.action.equals("action.kess.rewrapforreceiver")) {
            return new RewrapKeyForReceiverAction(this);
        }
        if (action.action.equals("action.kess.receivefromescrow")) {
            return new ReceiveKeyFromEscrowAction(this);
        }
        return null;
    }

    public SmartCardHSMCertificateChainTLV getExchangeChain() {
        try {
            return new SmartCardHSMCertificateChainTLV(HexString.parseHexString((String)this.getContent().exchangeChainTLV));
        }
        catch (TLVEncodingException e) {
            this.logger.error("Invalid exchange certificate chain", (Throwable)e);
            throw new ServiceRequestActionException("Invalid exchange certificate chain", (Throwable)e);
        }
    }
}

