/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.escrow.receive;

import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.HexString;
import java.security.cert.CertPathBuilderException;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import org.openscdp.pkicard.ServiceRequestSmartCardHSMAction;
import org.openscdp.pkicard.escrow.XKEKKeyDomain;
import org.openscdp.pkicard.escrow.receive.ReceiveKeyFromEscrowContent;
import org.openscdp.pkicard.escrow.receive.ReceiveKeyFromEscrowSharedServiceRequest;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.holder.escrow.KeyEscrow;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateExchangeKeyAction
extends ServiceRequestSmartCardHSMAction {
    private final Logger logger = LoggerFactory.getLogger(GenerateExchangeKeyAction.class);
    public static final String ACTION = "action.kess.generateexchangekey";
    private ReceiveKeyFromEscrowSharedServiceRequest serviceRequest;
    private ReceiveKeyFromEscrowContent content;
    private String tokenPath;
    private byte[] keyDomainUID;
    private String escrowName;

    public GenerateExchangeKeyAction(ReceiveKeyFromEscrowSharedServiceRequest serviceRequest) {
        super(ACTION, (ServiceRequest)serviceRequest);
        this.serviceRequest = serviceRequest;
        String lastSeenAt = serviceRequest.getBackendReceiverConnectedTo();
        if (lastSeenAt != null) {
            this.context = "@" + lastSeenAt;
        }
    }

    public String getKey() {
        return ACTION;
    }

    public ServiceRequest getServiceRequest() {
        return this.serviceRequest;
    }

    public boolean preFlightCheck() {
        this.content = this.serviceRequest.getContent();
        this.tokenPath = this.content.getTokenPath();
        if (this.tokenPath == null) {
            return false;
        }
        KeyEscrow keyEscrow = this.serviceRequest.getKeyEscrowHolder();
        this.escrowName = keyEscrow.getName();
        this.keyDomainUID = keyEscrow.getSigner().getKeyDomain();
        return this.keyDomainUID != null;
    }

    protected void assertReady(SmartCardHSMProvider provider) throws OpenCardException, CertPathBuilderException {
        if (!this.preFlightCheck()) {
            throw new ServiceRequestActionException("Precondition for service request not fulfilled");
        }
        SmartCardHSMCardService service = provider.getSmartCardHSMCardService();
        if (!service.getId().equals(this.tokenPath)) {
            throw new ServiceRequestActionException("Wrong Token presented");
        }
        try {
            if (provider.getSmartCardHSMCardService().getPasswordStatus(null, 1) != CHVCardServiceWithControl.PasswordStatus.VERIFIED) {
                throw new ServiceRequestActionException("Token " + this.tokenPath + " is not authenticated");
            }
        }
        catch (CardServiceException | CardTerminalException e) {
            this.logger.error("Device error", e);
            throw new ServiceRequestActionException("Error while processing token " + this.tokenPath, e);
        }
    }

    @Override
    public JSONActionResult execute() {
        String lastSeenAt = this.serviceRequest.getBackendReceiverConnectedTo();
        if (lastSeenAt == null) {
            return this.getStatus();
        }
        return this.execute(this.serviceRequest.getContent().getTokenPath());
    }

    @Override
    public void execute(SmartCardHSMProvider provider) {
        try {
            this.assertReady(provider);
            XKEKKeyDomain xkd = new XKEKKeyDomain(provider, this.keyDomainUID);
            xkd.generateExchangeKey(this.escrowName);
            this.content.exchangeChainTLV = HexString.hexifyByteArray((byte[])xkd.getEphemeralChain().getBytes());
            this.serviceRequest.setStatusInfo("Generated exchange key");
            this.serviceRequest.setLifeCycle(3);
            this.serviceRequest.assignToCAOfficer();
        }
        catch (Exception e) {
            this.logger.error("Generate exchange key failed", (Throwable)e);
            this.serviceRequest.setStatusInfo("Generate exchange key failed");
            throw new ServiceRequestActionException(e.getMessage(), (Throwable)e);
        }
    }
}

