/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.TrustStore;
import de.cardcontact.opencard.eac.cvc.PublicKeyReference;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustStoreLoader {
    private static final Logger logger = LoggerFactory.getLogger(TrustStoreLoader.class);

    private static CardVerifiableCertificate readCVC(File file) {
        try {
            byte[] bin = Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0]));
            CardVerifiableCertificate cvc = new CardVerifiableCertificate(bin);
            return cvc;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem reading CVC file " + file.getAbsolutePath(), e);
        }
    }

    public static void loadTrustStore(File dir) {
        String[] fnames;
        TrustStore trustStore = TrustStore.getInstance();
        for (String fname : fnames = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".cvcert");
            }
        })) {
            File f = new File(dir, fname);
            CardVerifiableCertificate cvc = TrustStoreLoader.readCVC(f);
            if (trustStore.getTrustedCertificate((PublicKeyReference)cvc.getCertificateHolderReference()) != null) continue;
            logger.info("Adding as trusted " + cvc.toString());
            trustStore.addTrustedCertificate(cvc);
        }
    }
}

