/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CardRequest;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CardWaiter
implements CTListener {
    private static final Logger logger = LoggerFactory.getLogger(CardWaiter.class);
    private SmartCard smartCard_ = null;
    private CardRequest cardRequest_ = null;
    private Object lockHandle_ = null;
    private CardTerminalException cardTerminalException_ = null;

    public CardWaiter(CardRequest cardRequest, Object lockHandle) throws CardTerminalException {
        logger.debug("[init] Request: " + String.valueOf(cardRequest));
        this.cardRequest_ = cardRequest;
        this.lockHandle_ = lockHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cardInserted(CardTerminalEvent ctEvent) {
        block9: {
            if (this.smartCard_ == null) {
                logger.debug("[cardInserted] CTEvent: " + String.valueOf(ctEvent));
                try {
                    this.smartCard_ = SmartCard.getSmartCard(ctEvent, this.cardRequest_, this.lockHandle_);
                    if (this.smartCard_ == null) break block9;
                    CardWaiter cardWaiter = this;
                    synchronized (cardWaiter) {
                        this.notify();
                    }
                }
                catch (CardTerminalException e) {
                    this.cardTerminalException_ = e;
                    CardWaiter cardWaiter = this;
                    synchronized (cardWaiter) {
                        this.notify();
                    }
                }
            }
        }
    }

    @Override
    public void cardRemoved(CardTerminalEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SmartCard waitForCard() throws CardTerminalException {
        long timeout = this.cardRequest_.getTimeout() * 1000;
        if (this.cardRequest_.getWaitBehavior() == 1) {
            EventGenerator.getGenerator().createEventsForPresentCards(this);
        }
        try {
            EventGenerator.getGenerator().addCTListener(this);
            while (!(this.cardRequest_.isTimeoutSet() && timeout <= 0L || this.smartCard_ != null)) {
                long waitStartTime = System.currentTimeMillis();
                try {
                    if (this.cardRequest_.isTimeoutSet()) {
                        this.wait(timeout);
                    } else {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                timeout -= System.currentTimeMillis() - waitStartTime;
                if (this.cardTerminalException_ == null) continue;
                throw this.cardTerminalException_;
            }
            logger.debug("[waitForCard] SmartCard obtained: " + String.valueOf(this.smartCard_));
            SmartCard smartCard = this.smartCard_;
            return smartCard;
        }
        finally {
            EventGenerator.getGenerator().removeCTListener(this);
        }
    }
}

