/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import java.util.Enumeration;
import opencard.core.service.CardService;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceScheduler;
import opencard.core.service.CardType;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CardServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(CardServiceFactory.class);

    public CardServiceFactory() {
        logger.debug("[init] instantiating");
    }

    protected CardService getCardServiceInstance(Class clazz, CardType type, CardServiceScheduler scheduler, SmartCard card, boolean block) throws CardServiceException {
        Class serviceClass = this.getClassFor(clazz, type);
        if (serviceClass != null) {
            return this.newCardServiceInstance(serviceClass, type, scheduler, card, block);
        }
        return null;
    }

    protected Class getClassFor(Class clazz, CardType type) {
        Enumeration services = this.getClasses(type);
        while (services.hasMoreElements()) {
            Class serviceClass = (Class)services.nextElement();
            logger.debug("[getClassFor] checking " + String.valueOf(serviceClass));
            if (!clazz.isAssignableFrom(serviceClass)) continue;
            return serviceClass;
        }
        return null;
    }

    protected CardService newCardServiceInstance(Class clazz, CardType type, CardServiceScheduler scheduler, SmartCard card, boolean blocking) throws CardServiceException {
        logger.debug("[newCardServiceInstance] instantiating " + String.valueOf(clazz));
        CardService instance = null;
        try {
            instance = (CardService)clazz.newInstance();
        }
        catch (NoSuchMethodError noSuchMethodError) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        if (instance != null) {
            instance.initialize(scheduler, card, blocking);
        }
        return instance;
    }

    protected abstract CardType getCardType(CardID var1, CardServiceScheduler var2) throws CardTerminalException;

    protected abstract Enumeration getClasses(CardType var1);
}

