/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.pkcs15;

import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.IntegerTLV;
import de.cardcontact.tlv.OctetString;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;

public class Path
extends ConstructedTLV {
    static final Tag TAG = Tag.TAG_SEQUENCE;
    static final Tag TAG_LENGTH = new Tag(0, -128, false);
    static final String NAME = "Path";

    public Path(TLV tlv) throws TLVEncodingException {
        super(tlv);
        this.setName(NAME);
        int i = 0;
        TLV c = (TLV)this.childs.get(i++);
        if (!(c instanceof OctetString)) {
            throw new TLVEncodingException("efidOrPath must be OCTET STRING");
        }
        c.setName("efidOrPath");
        if (this.childs.size() > 1) {
            if (!((c = (TLV)this.childs.get(i++)) instanceof IntegerTLV)) {
                throw new TLVEncodingException("index must be INTEGER");
            }
            c.setName("index");
            c = (TLV)this.childs.get(i);
            if (!c.getTag().equals(TAG_LENGTH)) {
                throw new TLVEncodingException("length must be INTEGER with Tag 80");
            }
            c = new IntegerTLV(c);
            this.childs.set(i, c);
            c.setName("length");
        }
    }

    public Path(byte[] efidOrPath) {
        super(TAG);
        this.setName(NAME);
        this.childs.add(new OctetString(efidOrPath));
    }

    public Path(byte[] efidOrPath, int index, int len) {
        super(TAG);
        this.setName(NAME);
        this.childs.add(new OctetString(efidOrPath));
        this.childs.add(new IntegerTLV(index));
        IntegerTLV c = new IntegerTLV(len);
        c.setTag(TAG_LENGTH);
        this.childs.add(c);
    }

    public byte[] getEFIDorPath() {
        return ((OctetString)this.childs.get(0)).getValue();
    }

    public int getIndex() {
        return (int)((IntegerTLV)this.childs.get(1)).getLong();
    }

    public int getLen() {
        return (int)((IntegerTLV)this.childs.get(2)).getLong();
    }
}

