/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector.pkidm;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.TrustStore;
import de.cardcontact.opencard.eac.cvc.PublicKeyReference;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMECPrivateKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKeySpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMParameterSpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.HexString;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.util.Calendar;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.openscdp.pkicard.ServiceRequestSmartCardHSMAction;
import org.openscdp.pkidm.servicerequest.ServiceRequest;

public class TestGenAndIssueAction
extends ServiceRequestSmartCardHSMAction {
    public TestGenAndIssueAction(ServiceRequest serviceRequest) {
        super(serviceRequest);
    }

    public static X509Certificate createSelfSignedCertWithAttestation(KeyStore keyStore, String alias, String algorithm) {
        X509Certificate cert;
        String issuer;
        ECPublicKey puk;
        CardVerifiableCertificate cvc;
        PrivateKey prk;
        try {
            prk = (PrivateKey)keyStore.getKey(alias, null);
            cvc = (CardVerifiableCertificate)keyStore.getCertificate(alias);
            CardVerifiableCertificate devaut = (CardVerifiableCertificate)keyStore.getCertificate("DeviceAuthenticationCertificate");
            CardVerifiableCertificate dica = (CardVerifiableCertificate)keyStore.getCertificate("DeviceIssuerCertificate");
            CardVerifiableCertificate srca = TrustStore.getInstance().getTrustedCertificate((PublicKeyReference)dica.getCertificationAuthorityReference());
            if (srca == null) {
                throw new RuntimeException("No trust anchor found");
            }
            dica.verify(srca);
            devaut.verify(dica);
            cvc.verify(devaut);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not validate key attestation", e);
        }
        ECPublicKey cvcp = (ECPublicKey)cvc.getPublicKey();
        ASN1ObjectIdentifier curveOid = ASN1ObjectIdentifier.fromContents((byte[])cvc.getCurveOID());
        String curveName = ECUtil.getCurveName((ASN1ObjectIdentifier)curveOid);
        if (cvcp instanceof BCECPublicKey) {
            try {
                ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)curveName);
                ECNamedCurveSpec spec = new ECNamedCurveSpec(curveName, parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH(), parameterSpec.getSeed());
                puk = new BCECPublicKey("EC", new ECPublicKeySpec(cvcp.getW(), (ECParameterSpec)spec), BouncyCastleProvider.CONFIGURATION);
                System.out.println(puk.getClass().getName());
                System.out.println(HexString.dump((byte[])puk.getEncoded()));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not convert public key", e);
            }
        } else {
            puk = cvcp;
        }
        String subject = issuer = "C=DE, O=CardContact, CN=Test Client Certificate";
        long ts = System.currentTimeMillis();
        BigInteger serial = BigInteger.valueOf(ts);
        Date from = new Date(ts);
        Calendar cal = Calendar.getInstance();
        cal.setTime(from);
        cal.add(1, 5);
        Date to = cal.getTime();
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(new X500Name(issuer), serial, from, to, new X500Name(subject), (PublicKey)puk);
        try {
            JcaX509ExtensionUtils eu = new JcaX509ExtensionUtils();
            SubjectKeyIdentifier skid = eu.createSubjectKeyIdentifier((PublicKey)puk);
            builder.addExtension(Extension.subjectKeyIdentifier, true, (ASN1Encodable)skid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ContentSigner signer = null;
        try {
            signer = new JcaContentSignerBuilder(algorithm).build(prk);
        }
        catch (OperatorCreationException e) {
            e.printStackTrace();
            return null;
        }
        X509CertificateHolder certholder = builder.build(signer);
        JcaX509CertificateConverter conv = new JcaX509CertificateConverter();
        try {
            cert = conv.getCertificate(certholder);
            cert.checkValidity(new Date());
            cert.verify(puk);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return cert;
    }

    public static KeyPair generateECKeyPair(SmartCardHSMProvider provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        SmartCardHSMECPrivateKeySpec ecSpec = new SmartCardHSMECPrivateKeySpec((AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1"));
        KeyPair kp = null;
        SmartCardHSMParameterSpec hsmParam = new SmartCardHSMParameterSpec("MyECDSA", (SmartCardHSMKeySpec)ecSpec);
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC//ECDSA-SHA-1", (Provider)provider);
        kpg.initialize((AlgorithmParameterSpec)hsmParam, null);
        kp = kpg.generateKeyPair();
        return kp;
    }

    public void execute(SmartCardHSMProvider provider) {
        try {
            KeyStore ks = KeyStore.getInstance("SmartCardHSMKeyStore", (Provider)provider);
            ks.load(null, null);
            String label = "MyECDSA";
            if (ks.containsAlias(label)) {
                ks.deleteEntry(label);
            }
            TestGenAndIssueAction.generateECKeyPair(provider);
            X509Certificate cert = TestGenAndIssueAction.createSelfSignedCertWithAttestation(ks, label, "SHA256withECDSA");
            ks.setCertificateEntry(label, cert);
        }
        catch (Exception e) {
            throw new ProviderException("Generating key and certificate failed", e);
        }
    }
}

