/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.datatypes;

import de.dfncert.datatypes.EmailAddress;
import de.dfncert.utils.UtilsFormat;
import de.dfncert.validators.IPAddress;

public class SubjectAltName {
    private Type type;
    private String value;

    public SubjectAltName(Type type, String value) {
        this.type = type;
        this.value = value;
        switch (type) {
            case IP: 
            case DNS: {
                this.value = value.toLowerCase();
            }
        }
    }

    public void validate() throws NoValidSANException {
        this.validate(false, false);
    }

    public void validate(boolean wildcardInDNSAllowed, boolean hostnameInDNSAllowed) throws NoValidSANException {
        if (!SubjectAltName.validate(this.type, this.value, wildcardInDNSAllowed, hostnameInDNSAllowed)) {
            throw new NoValidSANException("Der Wert '" + this.value + "' ist nicht zul\u00e4ssig f\u00fcr Altnames vom Typ '" + (Object)((Object)this.type));
        }
    }

    public static boolean validate(Type type, String value, boolean wildcardInDNSAllowed, boolean hostnameInDNSAllowed) {
        return type.validate(value, wildcardInDNSAllowed, hostnameInDNSAllowed);
    }

    public static boolean validate(String string) {
        return SubjectAltName.validate(string, false, false);
    }

    public static boolean validate(String string, boolean wildcardInDNSAllowed, boolean hostnameInDNSAllowed) {
        try {
            return SubjectAltName.validate(SubjectAltName.getTypeFromString(string), SubjectAltName.getValueFromString(string), wildcardInDNSAllowed, hostnameInDNSAllowed);
        }
        catch (NoValidSANException ex) {
            return false;
        }
    }

    public static Type getTypeFromString(String string) {
        String type;
        try {
            type = string.substring(0, string.indexOf(":"));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new NoValidSANException("No ':' found in SAN: " + string);
        }
        for (Type t : Type.values()) {
            if (!type.equalsIgnoreCase(t.toString())) continue;
            return t;
        }
        throw new NoValidSANException("Not an existing Type: " + type);
    }

    public static String getValueFromString(String string) {
        try {
            return string.substring(string.indexOf(":") + 1);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new NoValidSANException("No ':' found in SAN: " + string);
        }
    }

    public static SubjectAltName getFromString(String string) {
        return new SubjectAltName(SubjectAltName.getTypeFromString(string), SubjectAltName.getValueFromString(string));
    }

    public SubjectAltName(EmailAddress email) {
        this.type = Type.EMAIL;
        this.value = email.toString();
    }

    public String toString() {
        return (Object)((Object)this.type) + ":" + this.value;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isLegacy() {
        return this.type.isLegacy();
    }

    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 73 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubjectAltName other = (SubjectAltName)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.type == Type.EMAIL) {
            EmailAddress email = new EmailAddress(this.value);
            return email.equals(new EmailAddress(other.value));
        }
        return !(this.value != null ? !this.value.toLowerCase().equals(other.value.toLowerCase()) : other.value != null);
    }

    public static enum Type {
        IP("IP", false),
        DNS("DNS", false),
        EMAIL("email", false),
        MICROSOFTUPN("Microsoft_UPN", false),
        URI("URI", false),
        RID("RID", true),
        MICROSOFTGUID("Microsoft_GUID", true),
        OTHERNAME("otherName", true);

        private final String typeString;
        private final boolean legacy;

        private Type(String typeString, boolean legacy) {
            this.typeString = typeString;
            this.legacy = legacy;
        }

        public boolean validate(String value) {
            return this.validate(value, false, false);
        }

        public boolean validate(String value, boolean wildcardCertificateAllowed, boolean hostnameAllowed) {
            switch (this) {
                case IP: {
                    return IPAddress.isIP(value);
                }
                case DNS: {
                    boolean isValid = false;
                    if (IPAddress.isIP(value)) {
                        return isValid;
                    }
                    if (wildcardCertificateAllowed && hostnameAllowed) {
                        if (UtilsFormat.Patterns.DOMAIN_OR_WILDCARDDOMAIN.matches(value) || UtilsFormat.Patterns.HOSTNAME.matches(value)) {
                            isValid = true;
                        }
                    } else if (wildcardCertificateAllowed && !hostnameAllowed) {
                        if (UtilsFormat.Patterns.DOMAIN_OR_WILDCARDDOMAIN.matches(value)) {
                            isValid = true;
                        }
                    } else if (!wildcardCertificateAllowed && hostnameAllowed) {
                        if (UtilsFormat.Patterns.DOMAIN.matches(value) || UtilsFormat.Patterns.HOSTNAME.matches(value)) {
                            isValid = true;
                        }
                    } else if (!(wildcardCertificateAllowed && hostnameAllowed || !UtilsFormat.Patterns.DOMAIN.matches(value))) {
                        isValid = true;
                    }
                    return isValid;
                }
                case EMAIL: 
                case MICROSOFTUPN: {
                    return UtilsFormat.Patterns.EMAIL.matches(value);
                }
                case URI: {
                    return UtilsFormat.Patterns.TEXT.matches(value);
                }
            }
            return true;
        }

        public String toString() {
            return this.typeString;
        }

        public boolean isLegacy() {
            return this.legacy;
        }
    }

    public static class NoValidSANException
    extends IllegalArgumentException {
        public NoValidSANException(String string) {
            super(string);
        }
    }
}

