/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.datatypes;

import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class EmailAddress {
    private final String email;
    private final String local;
    private final String domain;
    private static final Pattern EMAIL_REGEXP = Pattern.compile("^(?=.{1,254}$)(?=.{1,64}@.+$)[a-zA-Z0-9]+([-_.+][a-zA-Z0-9]+)*@((xn--)|(XN--)?[a-zA-Z0-9]+([-_][a-zA-Z0-9]+)*\\.)+((xn--)|(XN--)?[a-zA-Z0-9]+)$");

    public EmailAddress(String email) {
        if (!EmailAddress.validate(email)) {
            throw new NoValidEmailAddressException("This is not a valid email address: " + email);
        }
        this.email = email;
        this.local = email.substring(0, email.indexOf("@"));
        this.domain = email.substring(email.indexOf("@") + 1);
    }

    public EmailAddress(String local, String domain) {
        this.local = local;
        this.domain = domain;
        this.email = local + "@" + domain;
        if (!EmailAddress.validate(this.email)) {
            throw new NoValidEmailAddressException("This is not a valid email address: " + this.email);
        }
    }

    public static boolean validate(String email) {
        try {
            InternetAddress internetAddress = new InternetAddress(email);
        }
        catch (AddressException ex) {
            return false;
        }
        return EMAIL_REGEXP.matcher(email).matches();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmailAddress other = new EmailAddress(obj.toString());
        return this.local.equals(other.local) && this.domain.toLowerCase().equals(other.domain.toLowerCase());
    }

    public String toString() {
        return this.email;
    }

    public String getLocal() {
        return this.local;
    }

    public String getDomain() {
        return this.domain;
    }

    public class NoValidEmailAddressException
    extends IllegalArgumentException {
        public NoValidEmailAddressException(String string) {
            super(string);
        }
    }
}

