/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.datatypes;

import de.dfncert.utils.UtilsFormat;
import de.dfncert.utils.crypto.DFNStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;

public class DN {
    private X500Name dn;
    public static final ASN1ObjectIdentifier E = DFNStyle.E;
    public static final ASN1ObjectIdentifier x500UniqueIdentifier = DFNStyle.x500UniqueIdentifier;
    public static final ASN1ObjectIdentifier UID = DFNStyle.UID;
    public static final ASN1ObjectIdentifier SERIALNUMBER = DFNStyle.SERIALNUMBER;
    public static final ASN1ObjectIdentifier CN = DFNStyle.CN;
    public static final ASN1ObjectIdentifier OU = DFNStyle.OU;
    public static final ASN1ObjectIdentifier O = DFNStyle.O;
    public static final ASN1ObjectIdentifier L = DFNStyle.L;
    public static final ASN1ObjectIdentifier ST = DFNStyle.ST;
    public static final ASN1ObjectIdentifier C = DFNStyle.C;
    public static final ASN1ObjectIdentifier DC = DFNStyle.DC;
    public static final ASN1ObjectIdentifier GN = DFNStyle.GN;
    public static final ASN1ObjectIdentifier SN = DFNStyle.SN;
    public static final ASN1ObjectIdentifier PSEUDONYM = DFNStyle.PSEUDONYM;
    public static final ASN1ObjectIdentifier subjectAltName = DFNStyle.subjectAltName;

    public DN(X500Name dn) {
        if (!DN.checkRDNValues(dn, false)) {
            throw new IllegalArgumentException("Ein oder mehrere RDNs in '" + dn.toString() + "' enthalten unerlaubte Zeichen. (Erlaubte Zeichen: \"a-z\", \"A-Z\", \"0-9\", \"()-./: ,\")");
        }
        if (!DN.checkRDNQuantity(dn)) {
            throw new IllegalArgumentException("Ein oder mehrere RDNs in '" + dn.toString() + "' sind in falscher Anzahl vorhanden oder fehlen. Die Attribute C und O m\u00fcssen genau einmal vorhanden sein.");
        }
        this.dn = DN.sorted(dn);
    }

    public DN(String dn) {
        this(new X500Name((X500NameStyle)DFNStyle.INSTANCE, dn));
    }

    public boolean hasSTandL() {
        return this.getST() != null && this.getL() != null;
    }

    public boolean isPseudonymOrGNSNOrGroup() {
        return this.isPseudonym() && !this.isGNSN() && !this.isGroup() || !this.isPseudonym() && this.isGNSN() && !this.isGroup() || !this.isPseudonym() && !this.isGNSN() && this.isGroup();
    }

    public boolean isGNSN() {
        return this.getSNs().size() > 0;
    }

    public boolean isPseudonym() {
        return this.getPseudonyms().size() > 0;
    }

    public boolean isGroup() {
        for (String cn : this.getCNs()) {
            if (!cn.startsWith("GRP")) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return DFNStyle.INSTANCE.toString(this.dn);
    }

    public static DN transformDN(DN dn) throws IllegalArgumentException {
        if (dn.getCNs().size() != 1) {
            throw new IllegalArgumentException("dn hat " + dn.getCNs().size() + " CNs");
        }
        String cnString = dn.getCNs().get(0);
        String pn = null;
        RDN[] rdns = dn.getX500Name().getRDNs();
        ArrayList<RDN> rdnsList = new ArrayList<RDN>(Arrays.asList(rdns));
        Pattern pPN = Pattern.compile("^(PN: ?|PN - ?)(.+)$");
        Matcher mPN = pPN.matcher(cnString);
        if (mPN.matches()) {
            pn = mPN.group(2);
            RDN pnRDN = new RDN(new AttributeTypeAndValue(DFNStyle.PSEUDONYM, (ASN1Encodable)new DERUTF8String(pn)));
            rdnsList.add(pnRDN);
        }
        RDN[] newrdns = rdnsList.toArray(new RDN[0]);
        X500Name newX500 = new X500Name(newrdns);
        return new DN(newX500);
    }

    public static ArrayList<String> getValues(X500Name dn, ASN1ObjectIdentifier oid) {
        if (dn == null) {
            throw new IllegalArgumentException("DN darf nicht null sein.");
        }
        if (oid == null) {
            throw new IllegalArgumentException("OID darf nicht null sein.");
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (RDN rdn : dn.getRDNs(oid)) {
            strings.add(rdn.getFirst().getValue().toString());
        }
        return strings;
    }

    private ArrayList<String> getValues(ASN1ObjectIdentifier oid) {
        return DN.getValues(this.dn, oid);
    }

    public static boolean checkRDNValues(X500Name dn, boolean bOnlyAllowed) {
        for (RDN rdn : dn.getRDNs()) {
            ASN1ObjectIdentifier type = rdn.getFirst().getType();
            if (bOnlyAllowed && !DFNStyle.identifierInOrder.contains(type)) {
                return false;
            }
            String value = rdn.getFirst().getValue().toString();
            if ((!type.equals((ASN1Primitive)E) || UtilsFormat.Patterns.EMAIL.matches(value)) && (!type.equals((ASN1Primitive)DC) && !type.equals((ASN1Primitive)C) && !type.equals((ASN1Primitive)ST) && !type.equals((ASN1Primitive)L) && !type.equals((ASN1Primitive)O) && !type.equals((ASN1Primitive)OU) && !type.equals((ASN1Primitive)SERIALNUMBER) || UtilsFormat.Patterns.TEXT.matches(value)) && (!type.equals((ASN1Primitive)SN) && !type.equals((ASN1Primitive)GN) && !type.equals((ASN1Primitive)PSEUDONYM) && !type.equals((ASN1Primitive)UID) || UtilsFormat.Patterns.TEXT_WITH_AT.matches(value)) && (!type.equals((ASN1Primitive)CN) || UtilsFormat.Patterns.DN_WITH_WILDCARD.matches(value))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkRDNValues(X500Name dn) {
        return DN.checkRDNValues(dn, true);
    }

    public static boolean checkRDNQuantity(X500Name dn) {
        for (RDN rdn : dn.getRDNs()) {
            if (!rdn.isMultiValued()) continue;
            return false;
        }
        return dn.getRDNs(C).length <= 1 && dn.getRDNs(ST).length <= 1 && dn.getRDNs(L).length <= 1 && dn.getRDNs(O).length <= 1 && dn.getRDNs(CN).length >= 1;
    }

    public static X500Name sorted(X500Name dn) {
        RDN[] rdns = dn.getRDNs();
        DFNStyle.sort(rdns);
        return new X500Name((X500NameStyle)DFNStyle.INSTANCE, rdns);
    }

    public ArrayList<String> getEmailAddresses() {
        return this.getValues(E);
    }

    public ArrayList<String> getX500UniqueIdentifiers() {
        return this.getValues(x500UniqueIdentifier);
    }

    public ArrayList<String> getUIDs() {
        return this.getValues(UID);
    }

    public ArrayList<String> getSerialNumbers() {
        return this.getValues(SERIALNUMBER);
    }

    public ArrayList<String> getCNs() {
        return this.getValues(CN);
    }

    public ArrayList<String> getGNs() {
        return this.getValues(GN);
    }

    public ArrayList<String> getSNs() {
        return this.getValues(SN);
    }

    public ArrayList<String> getPseudonyms() {
        return this.getValues(PSEUDONYM);
    }

    public ArrayList<String> getOUs() {
        return this.getValues(OU);
    }

    public String getO() {
        ArrayList<String> Os = this.getValues(O);
        assert (Os.size() == 1) : "In einem DN kann nur genau ein O vorkommen.";
        return Os.get(0);
    }

    public String getL() {
        ArrayList<String> Ls = this.getValues(L);
        assert (Ls.size() <= 1) : "In einem DN kann maximal ein L vorkommen.";
        return Ls.size() == 1 ? Ls.get(0) : null;
    }

    public String getST() {
        ArrayList<String> STs = this.getValues(ST);
        assert (STs.size() <= 1) : "In einem DN kann maximal ein ST vorkommen.";
        return STs.size() == 1 ? STs.get(0) : null;
    }

    public String getC() {
        ArrayList<String> Cs = this.getValues(C);
        assert (Cs.size() == 1) : "In einem DN kann nur genau ein C vorkommen.";
        return Cs.get(0);
    }

    public ArrayList<String> getDCs() {
        return this.getValues(DC);
    }

    public X500Name getX500Name() {
        return this.dn;
    }
}

