/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.holder;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.holder.Holder;
import org.openscdp.pkidm.holder.HolderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HolderFactoryRegistry {
    final Logger logger = LoggerFactory.getLogger(HolderFactoryRegistry.class);
    private Jdbi jdbi;
    HashMap<String, HolderFactory> registry = new HashMap();

    public void setJDBI(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    public void addHolderFactory(String type, HolderFactory factory) {
        if (this.registry.containsKey(type)) {
            this.logger.warn("Overwriting factory " + String.valueOf(this.registry.get(type)) + " for " + type + " with " + String.valueOf(factory));
        }
        this.registry.put(type, factory);
    }

    public void addHolderFactory(HolderFactory factory) {
        this.addHolderFactory(factory.getType(), factory);
    }

    public HolderFactory getFactoryForType(String type) {
        if (!this.registry.containsKey(type)) {
            this.logger.warn("No factory found for type " + type);
        }
        HolderFactory factory = this.registry.get(type);
        return factory;
    }

    public Holder getByDTO(HolderDTO dto) {
        String type = dto.getType();
        if (type == null) {
            throw new RuntimeException("Holder does not have a type");
        }
        HolderFactory factory = this.getFactoryForType(type);
        Holder holder = factory.getByDTO(dto);
        return holder;
    }

    public <T extends Holder> T getByDTO(HolderDTO dto, Class<T> type) {
        Holder result;
        if (dto.getType() != null) {
            Holder holder = this.getByDTO(dto);
            return (T)((Holder)type.cast(holder));
        }
        try {
            Constructor<T> cons = type.getConstructor(HolderDTO.class);
            result = (Holder)cons.newInstance(dto);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not construct holder for type " + type.descriptorString(), e);
        }
        return (T)result;
    }

    public <T extends Holder> T getById(Long id, Class<T> type) {
        HolderDTO dto;
        try (Handle handle = this.jdbi.open();){
            HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
            dto = dao.getHolder(id);
        }
        if (dto == null) {
            throw new RuntimeException("Holder with id " + id + " not found");
        }
        return this.getByDTO(dto, type);
    }
}

