/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.slight;

import de.dfncert.slight.RPCDeserializer;
import de.dfncert.slight.RPCSerializer;
import de.dfncert.slight.SOAPFaultException;
import de.dfncert.slight.SOAPTraceable;
import de.dfncert.soap.DFNCERTTypesExtendedRequestParameters;
import de.dfncert.soap.DFNCERTTypesSerializable;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.net.URL;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class SOAPClient {
    private URL endpoint;
    private static boolean debug;
    private String targetNamespace;
    private String targetPackage;
    private SSLSocketFactory sslFactory;
    private static SOAPTraceable traceable;
    private static DocumentBuilderFactory factory;

    public SOAPClient(String targetNamespace, String targetPackage) throws Exception {
        this.targetNamespace = targetNamespace;
        this.targetPackage = targetPackage;
        if (factory == null) {
            factory = DocumentBuilderFactory.newInstance();
            factory.setExpandEntityReferences(false);
            factory.setNamespaceAware(false);
            factory.setValidating(false);
        }
    }

    public static void setDebug(boolean debug) {
        SOAPClient.debug = debug;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setTraceable(SOAPTraceable traceable) {
        SOAPClient.traceable = traceable;
    }

    public void setEndpoint(URL endpoint) {
        this.endpoint = endpoint;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslFactory) {
        this.sslFactory = sslFactory;
    }

    /*
     * Unable to fully structure code
     */
    public Object doRequest(String methodName, String[] paramNames, Object[] paramValues) throws Exception {
        block31: {
            block32: {
                connect = null;
                try {
                    serializer = new RPCSerializer(this.targetNamespace);
                    requestDoc = serializer.getRequestDocument(methodName, paramNames, paramValues);
                    if (SOAPClient.isDebug() && SOAPClient.traceable == null) {
                        System.out.println("----> " + methodName + " (" + this.endpoint.toString() + ")");
                        System.out.println(this.dumpDocument(requestDoc, true));
                    }
                    measure = System.currentTimeMillis();
                    connect = (HttpsURLConnection)this.endpoint.openConnection();
                    if (this.sslFactory != null) {
                        connect.setSSLSocketFactory(this.sslFactory);
                    }
                    connect.setUseCaches(false);
                    connect.setDoOutput(true);
                    connect.setDoInput(true);
                    connect.addRequestProperty("Content-Type", "text/xml; charset=utf-8");
                    connect.addRequestProperty("SOAPAction", "\"\"");
                    connect.getOutputStream().write(this.dumpDocument(requestDoc, true).getBytes("UTF-8"));
                    builder = SOAPClient.factory.newDocumentBuilder();
                    if (SOAPClient.isDebug()) {
                        if (SOAPClient.traceable != null) {
                            SOAPClient.traceable.traceSOAPSent(connect, methodName, requestDoc);
                        }
                        buffer = new StringBuilder(1024);
                        inbuff = new byte[1024];
                        while ((len = connect.getInputStream().read(inbuff, 0, 1024)) > 0) {
                            buffer.append(new String(inbuff, 0, len));
                        }
                        in = new ByteArrayInputStream(buffer.toString().getBytes());
                        responseDoc = builder.parse(in);
                        if (SOAPClient.traceable != null) {
                            SOAPClient.traceable.traceSOAPReceived(connect, methodName, responseDoc);
                        } else {
                            System.out.println("<---- " + methodName);
                            System.out.println(buffer.toString());
                        }
                    } else {
                        responseDoc = builder.parse(connect.getInputStream());
                    }
                    if (SOAPClient.isDebug() && SOAPClient.traceable == null) {
                        System.out.print("<---> " + methodName);
                        System.out.println(" sent and received in " + (System.currentTimeMillis() - measure) + "ms");
                        System.out.println();
                    }
                    node = responseDoc.getDocumentElement();
                    while (node != null) {
                        if ((node = node.getFirstChild()).getNodeName().equalsIgnoreCase("soap-env:fault") || node.getNodeName().equalsIgnoreCase("soap:fault")) {
                            faultcode = null;
                            faultstring = null;
                            node = node.getFirstChild();
                            while (node != null) {
                                if (node.getNodeName().equals("faultcode")) {
                                    faultcode = node.getFirstChild().getNodeValue();
                                } else if (node.getNodeName().equals("faultstring")) {
                                    faultstring = node.getFirstChild().getNodeValue();
                                }
                                node = node.getNextSibling();
                            }
                            sex = new SOAPFaultException(faultcode, faultstring);
                            if (SOAPClient.traceable != null) {
                                SOAPClient.traceable.traceSOAPError(connect, methodName, responseDoc, sex);
                            }
                            throw sex;
                        }
                        if (node.getAttributes().getNamedItem("xsi:type") != null) break;
                    }
                    if (node == null) {
                        throw new Exception("response contains no element with xsi:type");
                    }
                    rpcin = new RPCDeserializer(this.targetPackage);
                    result = rpcin.deserializeDOM(node);
                    if (result instanceof DFNCERTTypesSerializable) {
                        if (result instanceof DFNCERTTypesExtendedRequestParameters) {
                            ((DFNCERTTypesExtendedRequestParameters)result).init();
                        } else {
                            ((DFNCERTTypesSerializable)result).init();
                        }
                    }
                    if (SOAPClient.isDebug() && SOAPClient.traceable == null && connect != null) {
                        System.err.println("URL:");
                        System.err.println(" " + connect.getURL().toString());
                        System.err.print("Client Chain: ");
                        chain = null;
                        try {
                            chain = (X509Certificate[])connect.getLocalCertificates();
                            if (chain != null) {
                                System.err.println();
                                i = 0;
                                while (i < chain.length) {
                                    System.err.println(String.format(" [%d] %s", new Object[]{i, chain[i].getSubjectDN().toString()}));
                                    ++i;
                                }
                            } else {
                                System.err.println("none");
                            }
                        }
                        catch (IllegalStateException ise) {
                            System.err.println("not yet sent");
                        }
                    }
                    return result;
                }
                catch (Exception e) {
                    if (!SOAPClient.isDebug() || SOAPClient.traceable != null || connect == null) break block31;
                    System.err.println("--- " + e.getMessage());
                    System.err.println("URL:");
                    System.err.println(" " + connect.getURL().toString());
                    System.err.print("Client Chain: ");
                    chain = null;
                    try {
                        chain = (X509Certificate[])connect.getLocalCertificates();
                    }
                    catch (IllegalStateException ise) {
                        System.err.println("not yet sent");
                    }
                    if (chain == null) break block32;
                    System.err.println();
                    i = 0;
                    ** while (i < chain.length)
                }
lbl-1000:
                // 1 sources

                {
                    System.err.println(String.format(" [%d] %s", new Object[]{i, chain[i].getSubjectDN().toString()}));
                    ++i;
                    continue;
lbl109:
                    // 1 sources

                    break block31;
                }
            }
            System.err.println("none");
        }
        throw e;
    }

    public String dumpDocument(Document document, boolean humanReadable) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ClassCastException {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        LSSerializer serializer = impl.createLSSerializer();
        LSOutput lsOutput = impl.createLSOutput();
        lsOutput.setEncoding("UTF-8");
        StringWriter stringWriter = new StringWriter();
        lsOutput.setCharacterStream(stringWriter);
        serializer.write(document, lsOutput);
        return stringWriter.toString();
    }
}

