/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector.pkidm.action;

import de.dfncert.tools.DFNPKIClient;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.openscdp.dfn.connector.pkidm.servicerequest.DFNCertificateRequestBase;
import org.openscdp.dfn.connector.pkidm.signer.RegistrationAuthority;
import org.openscdp.pkidb.dto.RequestDTO;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.action.ServiceRequestSingleAction;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFNCertReqAction
extends ServiceRequestSingleAction {
    final Logger logger = LoggerFactory.getLogger(DFNCertReqAction.class);
    private DFNCertificateRequestBase sr;
    private Long userId;
    private RegistrationAuthority ra;
    private DFNPKIClient client;

    public DFNCertReqAction(DFNCertificateRequestBase serviceRequest, Long userId) {
        super((ServiceRequest)serviceRequest);
        this.sr = serviceRequest;
        this.userId = userId;
    }

    public void requestCertificate() throws Exception {
        String pin = this.sr.getPIN();
        int serial = this.client.getPublic().newRequest(this.ra.getContent().raID, this.getRequestAsPEM(), this.sr.getSubjectAltNames(), this.sr.getRole(), pin, this.sr.getName(), this.sr.getEmail(), this.sr.getOrgUnit(), this.sr.isPublish(), this.sr.getSubjectDN());
        this.logger.info("Created request with serial " + serial);
        this.sr.setCertificateRequestSerialNumber(serial);
        this.sr.setStatusInfo("Request submitted to RA for approval");
        this.sr.setLifeCycle(5);
        this.sr.setRoleId(this.ra.getContent().raRoleId);
        this.sr.commit(this.userId, null);
    }

    private String getRequestAsPEM() throws IOException {
        RequestDTO request = this.sr.getRequest();
        PKCS10CertificationRequest pkcs10 = new PKCS10CertificationRequest(request.getBytes());
        StringWriter strWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)strWriter);
        pemWriter.writeObject((Object)pkcs10);
        pemWriter.close();
        return strWriter.toString();
    }

    protected void executeImpl() {
        this.ra = this.sr.getRA();
        try {
            this.client = new DFNPKIClient(this.ra.getCAName());
            this.requestCertificate();
        }
        catch (Exception e) {
            throw new ServiceRequestActionException("DFNCertReqAction failed (SR-ID: " + this.sr.getId() + "): " + e.getMessage(), (Throwable)e);
        }
    }
}

