/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector.pkidm.action;

import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.dfncert.soap.DFNCERTDomains;
import de.dfncert.soap.DFNCERTTypesCAInfo;
import de.dfncert.soap.DFNCERTTypesDomain;
import de.dfncert.soap.DFNCERTTypesDomainListResult;
import de.dfncert.soap.DFNCERTTypesRAInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.dfn.connector.pkidm.Utils;
import org.openscdp.dfn.connector.pkidm.action.DFNRegistrationAuthorityAction;
import org.openscdp.dfn.connector.pkidm.servicerequest.CreateDFNPKIRegistrationAuthorityServiceRequest;
import org.openscdp.dfn.connector.pkidm.servicerequest.CreateDFNPKIRegistrationAuthorityServiceRequestContent;
import org.openscdp.dfn.connector.pkidm.signer.DFNDomain;
import org.openscdp.dfn.connector.pkidm.signer.RegistrationAuthority;
import org.openscdp.dfn.connector.pkidm.signer.RegistrationAuthorityContent;
import org.openscdp.dfn.connector.pkidm.signer.RegistrationAuthorityGenerator;
import org.openscdp.dfn.connector.pkidm.subject.DFNPKI;
import org.openscdp.dfn.connector.pkidm.subject.DFNPKIContent;
import org.openscdp.dfn.connector.pkidm.subject.DFNPKIGenerator;
import org.openscdp.dfn.connector.pkidm.subject.DFNPKITrustCenter;
import org.openscdp.dfn.connector.pkidm.subject.DFNPKITrustCenterContent;
import org.openscdp.pkidb.dao.RoleDAO;
import org.openscdp.pkidb.dao.SignerDAO;
import org.openscdp.pkidb.dto.AssignedRoleDTO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.RoleDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.subject.SubjectContentView;
import org.openscdp.pkidm.subject.SubjectFactoryRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateRAAction
extends DFNRegistrationAuthorityAction {
    final Logger logger = LoggerFactory.getLogger(CreateRAAction.class);
    public static final String ACTION = "action.createra";
    private CreateDFNPKIRegistrationAuthorityServiceRequest sr;
    private CreateDFNPKIRegistrationAuthorityServiceRequestContent srContent;
    private Long userId;

    public CreateRAAction(CreateDFNPKIRegistrationAuthorityServiceRequest serviceRequest, Long userId) {
        super((ServiceRequest)serviceRequest, serviceRequest.getContent().name);
        this.sr = serviceRequest;
        this.srContent = this.sr.getContent();
        this.userId = userId;
    }

    public void execute(SmartCardHSMProvider provider) {
        this.authenticate(provider);
        this.createRA();
    }

    private void createRA() {
        DFNCERTTypesRAInfo[] raInfos;
        CertificateDTO caCert;
        DFNCERTTypesCAInfo pubCAInfo;
        try {
            pubCAInfo = this.client.getPublic().getCAInfo(this.srContent.raId);
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException("URL " + fnfe.getMessage() + " not found. Check CA Installation Name", fnfe);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        DFNPKITrustCenter tc = this.sr.getTrustCenter();
        DFNPKI subject = this.getSubject();
        if (subject == null) {
            subject = this.createSubject(tc.getOperatorRoleId(), pubCAInfo.getRoles());
        }
        try {
            caCert = this.importCertificateChain(pubCAInfo.getCAChain(), subject.getId());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not import certificate chain: " + e.getMessage(), e);
        }
        for (DFNCERTTypesRAInfo raInfo : raInfos = pubCAInfo.getRAInfos()) {
            RegistrationAuthority ra;
            DFNCERTTypesDomainListResult result;
            String name = this.srContent.name + "#" + raInfo.getID();
            String raName = name + " Registration Officer";
            long raRoleId = this.createRARole(raName, this.sr.getId(), this.userId);
            RegistrationAuthorityContent raContent = new RegistrationAuthorityContent();
            raContent.raID = raInfo.getID();
            raContent.raRoleId = raRoleId;
            raContent.caInstallationName = raInfo.getName();
            raContent.description = this.srContent.description;
            raContent.dnPrefixes = raInfo.getDNPrefixes();
            DFNCERTDomains domains = this.client.getDomains();
            try {
                result = domains.listDomains(raInfo.getID());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not list domains: " + e.getMessage(), e);
            }
            DFNCERTTypesDomain[] da = result.getResult();
            if (da != null) {
                raContent.domains = new DFNDomain[da.length];
                for (int i = 0; i < da.length; ++i) {
                    DFNCERTTypesDomain domain = da[i];
                    DFNDomain d = new DFNDomain();
                    d.name = domain.getName();
                    d.type = domain.getType();
                    d.secret = domain.isSecret();
                    d.approved = domain.isApproved();
                    d.approvedDate = domain.getApprovedDate();
                    raContent.domains[i] = d;
                }
            } else {
                raContent.domains = new DFNDomain[0];
            }
            Jdbi jdbi = PKIDMContext.getJDBI();
            SignerDTO dto = null;
            try (Handle handle = jdbi.open();){
                SignerDAO dao = (SignerDAO)handle.attach(SignerDAO.class);
                dto = dao.getSignerByHolderAndName(caCert.getHolderId(), name);
            }
            if (dto != null) {
                ra = new RegistrationAuthority(dto);
                ra.setContent(raContent);
                ra.commit();
                this.sr.setStatusInfo("Registration Authority updated");
            } else {
                RegistrationAuthorityGenerator gen = new RegistrationAuthorityGenerator(caCert.getHolderId(), this.srContent.name, raInfo.getID(), null);
                gen.setContent(raContent);
                ra = gen.generate();
                this.sr.setStatusInfo("Registration Authority created");
            }
            DFNPKITrustCenterContent content = tc.getContent();
            boolean isNewRAID = true;
            if (content.dfnpkiRA == null) {
                content.dfnpkiRA = new Long[]{ra.getId()};
            } else {
                for (Long raId : content.dfnpkiRA) {
                    if (raId != ra.getId()) continue;
                    isNewRAID = false;
                    break;
                }
                if (isNewRAID) {
                    Long[] list = new Long[content.dfnpkiRA.length + 1];
                    System.arraycopy(content.dfnpkiRA, 0, list, 0, content.dfnpkiRA.length);
                    list[list.length - 1] = ra.getId();
                    content.dfnpkiRA = list;
                }
            }
            if (!isNewRAID) continue;
            tc.updateContent((SubjectContentView)content);
            tc.commit();
        }
        this.sr.setLifeCycle(11);
        this.sr.commit(this.userId, null);
    }

    private DFNPKI getSubject() {
        SubjectFactoryRegistry subFactory = PKIDMContext.getSubjectFactoryRegistry();
        DFNPKI subject = null;
        try {
            subject = (DFNPKI)subFactory.getByName(this.srContent.name, "DFNPKI", DFNPKI.class);
        }
        catch (RuntimeException e) {
            this.logger.info("Subject not found", (Throwable)e);
        }
        return subject;
    }

    private DFNPKI createSubject(long operatorRoleId, String[] roles) {
        DFNPKIGenerator subjectGen = new DFNPKIGenerator(this.srContent.name, this.sr.getId(), operatorRoleId);
        DFNPKIContent c = new DFNPKIContent();
        c.roles = roles;
        subjectGen.setContent((SubjectContentView)c);
        DFNPKI subject = subjectGen.generate();
        return subject;
    }

    private long createRARole(String name, long srId, long subjectId) {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            Long roleId;
            RoleDAO roleDAO = (RoleDAO)handle.attach(RoleDAO.class);
            RoleDTO role = roleDAO.getRole(name);
            if (role == null) {
                role = new RoleDTO();
                role.setName(name);
                roleId = roleDAO.insert(role);
            } else {
                roleId = role.getId();
            }
            AssignedRoleDTO assignedRole = roleDAO.getAssignedRole(subjectId, roleId.longValue());
            if (assignedRole == null) {
                assignedRole = new AssignedRoleDTO();
                assignedRole.setRoleId(roleId);
                assignedRole.setServiceRequestId(Long.valueOf(srId));
                assignedRole.setSubjectId(Long.valueOf(subjectId));
                roleDAO.insert(assignedRole);
            }
            long l = roleId;
            return l;
        }
    }

    private CertificateDTO importCertificateChain(String[] chain, long subjectId) throws CertificateException, IOException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        HashMap<BigInteger, X509Certificate> imported = new HashMap<BigInteger, X509Certificate>();
        CertificateDTO certDTO = null;
        for (int i = chain.length - 1; i >= 0; --i) {
            String pem = chain[i];
            PEMParser p = new PEMParser((Reader)new StringReader(pem));
            JcaX509CertificateConverter x509Converter = new JcaX509CertificateConverter();
            X509Certificate certificate = x509Converter.getCertificate((X509CertificateHolder)p.readObject());
            System.out.println(certificate);
            System.out.println();
            if (Utils.isRootCertificate(certificate)) {
                certificate.verify(certificate.getPublicKey());
                certDTO = Utils.importCertificate(certificate, null, true, this.sr.getId());
                BigInteger skid = new BigInteger(1, Utils.getSubjectKeyId(certificate));
                imported.put(skid, certificate);
                continue;
            }
            BigInteger akid = new BigInteger(1, Utils.getAuthorityKeyIdentifier(certificate));
            X509Certificate issuingCert = (X509Certificate)imported.get(akid);
            if (issuingCert == null) {
                throw new CertificateException("Invalid certificate chain");
            }
            certificate.verify(issuingCert.getPublicKey());
            if (i > 0) {
                BigInteger skid = new BigInteger(1, Utils.getSubjectKeyId(certificate));
                imported.put(skid, certificate);
                certDTO = Utils.importCertificate(certificate, null, true, this.sr.getId());
                continue;
            }
            certDTO = Utils.importCertificate(certificate, subjectId, true, this.sr.getId());
        }
        return certDTO;
    }
}

