/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector.pkidm;

import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.dfncert.soap.DFNCERTTypesCAInfo;
import de.dfncert.soap.DFNCERTTypesCAStatus;
import de.dfncert.tools.DFNPKIClient;
import java.security.KeyStore;
import java.security.Provider;
import java.security.ProviderException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.LinkedList;
import org.openscdp.pkicard.ServiceRequestSmartCardHSMAction;
import org.openscdp.pkidm.servicerequest.ServiceRequest;

public class RACardActionBase
extends ServiceRequestSmartCardHSMAction {
    public RACardActionBase(ServiceRequest serviceRequest) {
        super(serviceRequest);
    }

    public void execute(SmartCardHSMProvider provider) {
        try {
            KeyStore ksKeys = KeyStore.getInstance("SmartCardHSMKeyStore", (Provider)provider);
            ksKeys.load(null, null);
            DFNPKIClient client = new DFNPKIClient("test-client1-ca");
            DFNCERTTypesCAInfo info = client.getPublic().getCAInfo(60);
            System.out.println(info.getRoles()[0]);
            LinkedList<String> candidates = new LinkedList<String>();
            Enumeration<String> aliases = ksKeys.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = ksKeys.getCertificate(alias);
                if (cert == null) continue;
                System.out.println(cert);
                if (!ksKeys.isKeyEntry(alias)) continue;
                candidates.add(alias);
            }
            System.out.println("Candidates " + String.valueOf(candidates));
            String raAlias = null;
            for (String alias : candidates) {
                if (!alias.contains("RAID")) continue;
                raAlias = alias;
                break;
            }
            if (raAlias == null) {
                raAlias = (String)candidates.getFirst();
            }
            System.out.println("Authenticate with alias " + raAlias);
            client.loadRAFromKeystore(ksKeys, raAlias, null);
            DFNCERTTypesCAStatus status = client.getRegistration().getCAStatus();
            System.out.println("Req : " + status.getRequestNewCount());
        }
        catch (Exception e) {
            throw new ProviderException("Connect failed", e);
        }
    }
}

