/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector;

import de.cardcontact.opencard.factory.SmartCardHSMCardServiceFactory;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.OpenCardPropertyLoadingException;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.openscdp.dfn.connector.pkidm.servicerequest.CreateDFNPKIRegistrationAuthorityServiceRequest;
import org.openscdp.dfn.connector.pkidm.servicerequest.DFNCertificateRequestBase;
import org.openscdp.dfn.connector.pkidm.servicerequest.SAPCertificateServiceRequest;
import org.openscdp.dfn.connector.pkidm.subject.DFNPKI;
import org.openscdp.dfn.connector.pkidm.subject.DFNPKITrustCenter;
import org.openscdp.pkicard.ServiceRequestCardSessionFactory;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.X509ServiceRequests;
import org.openscdp.pkidm.X509Subjects;
import org.openscdp.pkidm.servicerequest.ServiceRequestFactory;
import org.openscdp.pkidm.servicerequest.ServiceRequestFactoryBase;
import org.openscdp.pkidm.servicerequest.ServiceRequestFactoryRegistry;
import org.openscdp.pkidm.subject.SubjectFactory;
import org.openscdp.pkidm.subject.SubjectFactoryBase;
import org.openscdp.pkidm.subject.SubjectFactoryRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFNConnectorServletContextListener
implements ServletContextListener {
    final Logger logger = LoggerFactory.getLogger(DFNConnectorServletContextListener.class);
    public static final String ATTRIBUTE_PKIDM = "PKIDM";
    Jdbi jdbi;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        String url = ctx.getInitParameter("database.url");
        String user = ctx.getInitParameter("database.user");
        String password = ctx.getInitParameter("database.password");
        Jdbi jdbi = Jdbi.create((String)url, (String)user, (String)password);
        jdbi.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        try {
            System.setProperty("OpenCard.loaderClassName", "");
            SmartCard.start();
            CardServiceRegistry csr = CardServiceRegistry.getRegistry();
            SmartCardHSMCardServiceFactory csf = new SmartCardHSMCardServiceFactory();
            csr.add((CardServiceFactory)csf);
        }
        catch (OpenCardPropertyLoadingException e) {
            this.logger.error("Error loading Opencard properties", (Throwable)e);
        }
        catch (CardServiceException e) {
            this.logger.error("Error creating card service", (Throwable)e);
        }
        catch (CardTerminalException e) {
            this.logger.error("Error creating terminal service", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Terminal or service factory not found", (Throwable)e);
        }
        ctx.setAttribute("cardSessionFactory", (Object)new ServiceRequestCardSessionFactory());
        PKIDMContext.setJDBI((Jdbi)jdbi);
        X509ServiceRequests.addServiceRequestFactories((Jdbi)jdbi);
        X509Subjects.addSubjectFactories((Jdbi)jdbi);
        ServiceRequestFactoryRegistry registry = PKIDMContext.getServiceRequestFactoryRegistry();
        registry.addServiceRequestFactory((ServiceRequestFactory)new ServiceRequestFactoryBase(CreateDFNPKIRegistrationAuthorityServiceRequest.class));
        registry.addServiceRequestFactory((ServiceRequestFactory)new ServiceRequestFactoryBase(DFNCertificateRequestBase.class));
        registry.addServiceRequestFactory((ServiceRequestFactory)new ServiceRequestFactoryBase(SAPCertificateServiceRequest.class));
        SubjectFactoryRegistry subjectFactory = PKIDMContext.getSubjectFactoryRegistry();
        subjectFactory.addSubjectFactory((SubjectFactory)new SubjectFactoryBase(DFNPKI.class));
        subjectFactory.addSubjectFactory((SubjectFactory)new SubjectFactoryBase(DFNPKITrustCenter.class));
        ctx.setAttribute(ATTRIBUTE_PKIDM, (Object)PKIDMContext.getInstance());
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        PKIDMContext pkidmctx = (PKIDMContext)ctx.getAttribute(ATTRIBUTE_PKIDM);
        if (pkidmctx != null) {
            ctx.removeAttribute(ATTRIBUTE_PKIDM);
        }
    }
}

