/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.groupsigner;

import de.cardcontact.opencard.service.smartcardhsm.KeyDomain;
import java.util.ArrayList;
import java.util.List;
import org.openscdp.pkicard.BackendToken;
import org.openscdp.pkicard.groupsigner.CreateGroupSignerAction;
import org.openscdp.pkicard.groupsigner.CreateSignerContent;
import org.openscdp.pkicard.groupsigner.EnumerateKeyDomains;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.action.ServiceRequestSaveAction;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.json.JSONKeyDomain;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestBase;
import org.openscdp.pkidm.subject.TrustCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGroupSharedServiceRequest
extends ServiceRequestBase
implements BackendToken {
    public static final String PROCESS = "CreateGroup";
    private final Logger logger = LoggerFactory.getLogger(CreateGroupSharedServiceRequest.class);
    private TrustCenter trustCenter;
    private CreateSignerContent signerContent;

    public CreateGroupSharedServiceRequest(ServiceRequestDTO dto) {
        super(dto);
    }

    public ServiceRequestAction getActionFor(JSONAction action) {
        if (action.action.equals("action.save")) {
            return new ServiceRequestSaveAction((ServiceRequest)this);
        }
        if (action.action.equals("action.kess.enumeratekeydomains")) {
            return new EnumerateKeyDomains(this);
        }
        if (action.action.equals("action.signer.create")) {
            return new CreateGroupSignerAction(this);
        }
        return null;
    }

    public TrustCenter getTrustCenter() {
        if (this.trustCenter == null) {
            Long tId = this.getRecipientId();
            this.trustCenter = (TrustCenter)PKIDMContext.getSubjectFactoryRegistry().getById(tId, TrustCenter.class);
        }
        return this.trustCenter;
    }

    public CreateSignerContent getContent() {
        if (this.signerContent == null) {
            this.signerContent = (CreateSignerContent)this.getContentView(CreateSignerContent.class);
        }
        return this.signerContent;
    }

    @Override
    public String getTokenPath() {
        return this.getContent().getTokenPath();
    }

    public void setKeyDomains(byte[] defaultKDUID, List<KeyDomain> keyDomains) {
        CreateSignerContent content = this.getContent();
        content.keyDomainList = new ArrayList<JSONKeyDomain>(keyDomains.size() + 1);
        content.keyDomainList.add(new JSONKeyDomain(defaultKDUID, "Default"));
        for (KeyDomain kd : keyDomains) {
            if (!kd.isCreated()) continue;
            content.keyDomainList.add(new JSONKeyDomain(kd));
        }
    }

    public JSONKeyDomain getKeyDomain() {
        CreateSignerContent content = this.getContent();
        if (content.keyDomainList == null || content.keyDomain == null) {
            return null;
        }
        int id = this.getContent().getKeyDomain().intValue();
        if (id < 0 || id >= this.getContent().keyDomainList.size()) {
            return null;
        }
        return this.getContent().keyDomainList.get(id);
    }
}

