/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.service;

import opencard.core.service.CHVDialog;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ExtendedVerifiedAPDUInterface;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.terminal.VerifiedAPDUInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardChannel {
    private static final Logger logger = LoggerFactory.getLogger(CardChannel.class);
    private SlotChannel slot_channel = null;
    private boolean is_open = false;
    private boolean is_jammed = false;
    private Object channel_state = null;

    protected CardChannel(SlotChannel slotchannel) {
        this.slot_channel = slotchannel;
        this.is_open = false;
        this.is_jammed = false;
        logger.debug("[init] (" + String.valueOf(slotchannel) + ")");
    }

    public final boolean isOpen() {
        return this.is_open;
    }

    private void assertCardChannelOpen() throws InvalidCardChannelException {
        if (!this.is_open) {
            throw new InvalidCardChannelException("CardChannel not open");
        }
    }

    public CardTerminal getCardTerminal() {
        this.assertCardChannelOpen();
        return this.slot_channel.getCardTerminal();
    }

    public SlotChannel getSlotChannel() {
        this.assertCardChannelOpen();
        return this.slot_channel;
    }

    public final void setState(Object state) {
        this.channel_state = state;
    }

    public final Object getState() {
        return this.channel_state;
    }

    public ResponseAPDU sendCommandAPDU(CommandAPDU cmdAPDU) throws InvalidCardChannelException, CardTerminalException {
        this.assertCardChannelOpen();
        ResponseAPDU rapdu = this.slot_channel.sendAPDU(cmdAPDU);
        return rapdu;
    }

    @Deprecated
    public final ResponseAPDU sendVerifiedAPDU(CommandAPDU command, CHVControl control, CHVDialog dialog, int timeout) throws InvalidCardChannelException, CardTerminalException, CardServiceInvalidCredentialException {
        return this.sendVerifiedAPDU(command, control, dialog);
    }

    public final ResponseAPDU sendVerifiedAPDU(CommandAPDU command, CHVControl control, CHVDialog dialog) throws InvalidCardChannelException, CardTerminalException, CardServiceInvalidCredentialException {
        VerifiedAPDUInterface terminal;
        this.assertCardChannelOpen();
        logger.debug("[sendVerifiedAPDU] (" + String.valueOf(command) + ")");
        ResponseAPDU response = null;
        CardTerminal ct = this.getCardTerminal();
        boolean hasSendVerifiedCommandAPDU = ct instanceof VerifiedAPDUInterface;
        if (ct instanceof ExtendedVerifiedAPDUInterface) {
            terminal = (ExtendedVerifiedAPDUInterface)((Object)ct);
            hasSendVerifiedCommandAPDU = terminal.hasSendVerifiedCommandAPDU();
        }
        if (!hasSendVerifiedCommandAPDU) {
            throw new CardTerminalException("CardTerminal does not support secure PIN entry");
        }
        terminal = (VerifiedAPDUInterface)((Object)ct);
        response = terminal.sendVerifiedCommandAPDU(this.slot_channel, command, control);
        logger.debug("[sendVerifiedAPDU] response: " + String.valueOf(response));
        return response;
    }

    public void open() throws InvalidCardChannelException {
        logger.trace("[open] opening CardChannel");
        if (this.is_jammed) {
            throw new InvalidCardChannelException("cannot be opened anymore");
        }
        if (this.is_open) {
            throw new InvalidCardChannelException("already open");
        }
        this.is_open = true;
    }

    public void close() {
        this.is_open = false;
        logger.trace("[close] CardChannel closed");
    }

    protected void closeFinal() {
        logger.debug("[closeFinal] closing for good");
        this.close();
        this.is_jammed = true;
    }

    public void finalize() {
        this.closeFinal();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(", ").append(this.is_open ? "is" : "not").append(" open");
        sb.append(", ").append(this.is_jammed ? "is" : "not").append(" jammed");
        return sb.toString();
    }
}

