/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.softTA;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.PKCS8;
import de.cardcontact.opencard.eac.TerminalAuthenticationSigner;
import de.cardcontact.opencard.eac.cvc.ECSignature;
import java.io.File;
import java.io.FileInputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;

public class SoftTASigner
implements TerminalAuthenticationSigner {
    String cspath;
    String signerpath;
    String signerCHR;
    ArrayList<CardVerifiableCertificate> chain = new ArrayList();
    PrivateKey signer;

    public SoftTASigner(String cspath, String signerpath) {
        this.cspath = cspath;
        this.signerpath = signerpath;
        try {
            this.setup();
        }
        catch (Exception e) {
            throw new RuntimeException("Problem setting up signer", e);
        }
    }

    private byte[] loadBinary(String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            throw new RuntimeException("File " + filename + " does not exist");
        }
        int len = (int)f.length();
        byte[] bin = new byte[len];
        try {
            FileInputStream fis = new FileInputStream(f);
            fis.read(bin);
            fis.close();
        }
        catch (Exception e) {
            throw new RuntimeException("File " + filename + " could not be read", e);
        }
        return bin;
    }

    private void loadCertificate(String path, String chr) throws CertificateException {
        String filename = this.cspath + path + "/" + chr + ".cvcert";
        File f = new File(filename);
        if (!f.exists()) {
            filename = this.cspath + path + "/" + chr + ".selfsigned.cvcert";
        }
        byte[] bin = this.loadBinary(filename);
        CardVerifiableCertificate cvc = new CardVerifiableCertificate(bin);
        this.chain.add(0, cvc);
    }

    private void loadPrivateKey(String path, String chr) throws Exception {
        String filename = this.cspath + path + "/" + chr + ".pkcs8";
        byte[] bin = this.loadBinary(filename);
        this.signer = PKCS8.decodePrivateKey(bin);
    }

    private void setup() throws Exception {
        String seq = "00001";
        String[] elem = this.signerpath.substring(1).split("/");
        String path = this.signerpath;
        String chr = elem[elem.length - 1] + seq;
        this.loadCertificate(path, chr);
        path = path.substring(0, path.lastIndexOf(47));
        String car = new String(this.chain.get(0).getCertificationAuthorityReference().getValue());
        this.loadCertificate(path, car);
        path = path.substring(0, path.lastIndexOf(47));
        car = new String(this.chain.get(0).getCertificationAuthorityReference().getValue());
        this.loadCertificate(path, car);
        car = new String(this.chain.get(0).getCertificationAuthorityReference().getValue());
        while (!car.equals(new String(this.chain.get(0).getCertificateHolderReference().getValue()))) {
            this.loadCertificate(path, car);
            car = new String(this.chain.get(0).getCertificationAuthorityReference().getValue());
        }
        this.loadPrivateKey(this.signerpath, chr);
        CardVerifiableCertificate cvc = this.chain.get(0);
        String algo = "SHA256withECDSA";
        PublicKey pub = cvc.getPublicKey();
        for (int i = 1; i < this.chain.size(); ++i) {
            cvc = this.chain.get(i);
            cvc.verify(pub, algo, null);
            pub = cvc.getPublicKey();
        }
        this.signerCHR = new String(cvc.getCertificateHolderReference().getValue());
        byte[] hash = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1};
        algo = "NONEwithECDSA";
        Signature signer = Signature.getInstance(algo);
        signer.initSign(this.signer);
        signer.update(hash);
        byte[] res = signer.sign();
        signer = Signature.getInstance(algo);
        signer.initVerify(pub);
        signer.update(hash);
        boolean ok = signer.verify(res);
        if (!ok) {
            throw new GeneralSecurityException("Signer validation failed. Private key matches certificate ?");
        }
    }

    @Override
    public byte[][] getCertificateChain(String keyCAR) {
        String car;
        int i;
        for (i = this.chain.size() - 1; i >= 0 && !(car = new String(this.chain.get(i).getCertificationAuthorityReference().getValue())).equals(keyCAR); --i) {
        }
        if (i < 0) {
            throw new RuntimeException("No certificate along the chain found that can be verified with " + keyCAR);
        }
        int s = this.chain.size() - i;
        byte[][] res = new byte[s][];
        for (int j = 0; j < s; ++j) {
            byte[] enc = null;
            try {
                enc = this.chain.get(i + j).getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
            res[j] = enc;
        }
        return res;
    }

    @Override
    public byte[] getTASignature(byte[] dataTBS, String keyCHR) {
        if (!keyCHR.equals(this.signerCHR)) {
            throw new RuntimeException("Key " + keyCHR + " not found");
        }
        byte[] signature = null;
        CardVerifiableCertificate cvc = this.chain.get(0);
        String algo = cvc.getSignatureAlgorithm();
        try {
            Signature signer = Signature.getInstance(algo);
            signer.initSign(this.signer);
            signer.update(dataTBS);
            signature = signer.sign();
            if (this.signer instanceof ECPrivateKey) {
                int keysize = ((ECPrivateKey)this.signer).getParams().getCurve().getField().getFieldSize();
                keysize = keysize + 7 >> 3;
                signature = ECSignature.unwrapSignature(signature, keysize);
            }
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Problem signing challenge", e);
        }
        return signature;
    }
}

