/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidb;

import java.lang.reflect.Field;
import java.util.Objects;

public class Filter {
    private String key;
    private Object value;
    private OPERATOR op;

    public Filter(String key, Object value, OPERATOR op) {
        this.key = key;
        this.value = value;
        this.op = op;
    }

    public boolean validateKey(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (!f.getName().equals(this.key)) continue;
            return true;
        }
        return false;
    }

    public String getFilter() {
        return this.key + " " + this.op.toString() + " ?";
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "Filter [key=" + this.key + ", value=" + String.valueOf(this.value) + ", op=" + String.valueOf((Object)this.op) + "]";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.op, this.value});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equals(this.key, other.key) && this.op == other.op && Objects.equals(this.value, other.value);
    }

    public static enum OPERATOR {
        lt("<"),
        lte("<="),
        eq("="),
        ne("!="),
        gt(">"),
        gte(">="),
        like("LIKE");

        private String value;

        private OPERATOR(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

