/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.soap;

import de.dfncert.datatypes.Role;
import de.dfncert.datatypes.SubjectAltName;
import de.dfncert.enums.RevocationReason;
import de.dfncert.slight.SOAPClient;
import de.dfncert.soap.DFNCERTTypesCAInfo;
import de.dfncert.soap.DFNCERTTypesRequestInfo;
import de.dfncert.soap.DFNCERTTypesValidDomain;
import java.math.BigInteger;
import java.util.List;

public class DFNCERTPublic {
    private SOAPClient client = new SOAPClient("https://pki.pca.dfn.de/DFNCERT/Public", "de.dfncert.soap");

    public SOAPClient getSOAPClient() {
        return this.client;
    }

    public Integer newRequest(int RaID, String PKCS10, String[] AltNames, String Role2, String Pin, String AddName, String AddEMail, String AddOrgUnit, boolean Publish) throws Exception {
        String[] paramNames = new String[]{"RaID", "PKCS10", "AltNames", "Role", "Pin", "AddName", "AddEMail", "AddOrgUnit", "Publish"};
        Object[] paramValues = new Object[]{RaID, PKCS10, AltNames, Role2, Pin, AddName, AddEMail, AddOrgUnit, Publish};
        return (Integer)this.client.doRequest("newRequest", paramNames, paramValues);
    }

    public Integer newRequest(int RaID, String PKCS10, List<SubjectAltName> altNames, Role role, String Pin, String AddName, String AddEMail, String AddOrgUnit, boolean Publish) throws Exception {
        String[] stringAltNames = new String[altNames.size()];
        int i = 0;
        for (SubjectAltName san : altNames) {
            stringAltNames[i] = san.toString();
            ++i;
        }
        return this.newRequest(RaID, PKCS10, stringAltNames, role.toString(), Pin, AddName, AddEMail, AddOrgUnit, Publish);
    }

    public Integer newRequest(int RaID, String PKCS10, String[] AltNames, String Role2, String Pin, String AddName, String AddEMail, String AddOrgUnit, boolean Publish, String Subject2) throws Exception {
        String[] paramNames = new String[]{"RaID", "PKCS10", "AltNames", "Role", "Pin", "AddName", "AddEMail", "AddOrgUnit", "Publish", "Subject"};
        Object[] paramValues = new Object[]{RaID, PKCS10, AltNames, Role2, Pin, AddName, AddEMail, AddOrgUnit, Publish, Subject2};
        return (Integer)this.client.doRequest("newRequest", paramNames, paramValues);
    }

    public Integer newRequest(int RaID, String PKCS10, List<SubjectAltName> altNames, Role role, String Pin, String AddName, String AddEMail, String AddOrgUnit, boolean Publish, String Subject2) throws Exception {
        String[] stringAltNames = new String[altNames.size()];
        int i = 0;
        for (SubjectAltName san : altNames) {
            stringAltNames[i] = san.toString();
            ++i;
        }
        return this.newRequest(RaID, PKCS10, stringAltNames, role.toString(), Pin, AddName, AddEMail, AddOrgUnit, Publish, Subject2);
    }

    @Deprecated
    public Integer newRevocationRequest(int RaID, BigInteger Serial, String Reason, String Pin) throws Exception {
        String[] paramNames = new String[]{"RaID", "Serial", "Reason", "Pin"};
        Object[] paramValues = new Object[]{RaID, Serial, Reason, Pin};
        return (Integer)this.client.doRequest("newRevocationRequest", paramNames, paramValues);
    }

    public Integer newRevocationRequest(int RaID, BigInteger Serial, RevocationReason Reason, String Pin) throws Exception {
        String[] paramNames = new String[]{"RaID", "Serial", "Reason", "Pin"};
        Object[] paramValues = new Object[]{RaID, Serial, Reason.getReasonCode(), Pin};
        return (Integer)this.client.doRequest("newRevocationRequest", paramNames, paramValues);
    }

    public byte[] getRequestPrintout(int RaID, int Serial, String Format2, String Pin) throws Exception {
        String[] paramNames = new String[]{"RaID", "Serial", "Format", "Pin"};
        Object[] paramValues = new Object[]{RaID, Serial, Format2, Pin};
        return (byte[])this.client.doRequest("getRequestPrintout", paramNames, paramValues);
    }

    public DFNCERTTypesRequestInfo getRequestInfo(int RaID, int Serial, String Pin) throws Exception {
        String[] paramNames = new String[]{"RaID", "Serial", "Pin"};
        Object[] paramValues = new Object[]{RaID, Serial, Pin};
        return (DFNCERTTypesRequestInfo)this.client.doRequest("getRequestInfo", paramNames, paramValues);
    }

    public String getCertificateByRequestSerial(int RaID, int Serial, String Pin) throws Exception {
        String[] paramNames = new String[]{"RaID", "Serial", "Pin"};
        Object[] paramValues = new Object[]{RaID, Serial, Pin};
        return (String)this.client.doRequest("getCertificateByRequestSerial", paramNames, paramValues);
    }

    public DFNCERTTypesCAInfo getCAInfo(int RaID) throws Exception {
        String[] paramNames = new String[]{"RaID"};
        Object[] paramValues = new Object[]{RaID};
        return (DFNCERTTypesCAInfo)this.client.doRequest("getCAInfo", paramNames, paramValues);
    }

    public DFNCERTTypesValidDomain[] getValidDomains(int RaID, String Type2) throws Exception {
        String[] paramNames = new String[]{"RaID", "Type"};
        Object[] paramValues = new Object[]{RaID, Type2};
        return (DFNCERTTypesValidDomain[])this.client.doRequest("getValidDomains", paramNames, paramValues);
    }
}

