/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.subject;

import java.util.HashMap;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.SubjectDAO;
import org.openscdp.pkidb.dto.SubjectDTO;
import org.openscdp.pkidm.subject.Subject;
import org.openscdp.pkidm.subject.SubjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectFactoryRegistry {
    final Logger logger = LoggerFactory.getLogger(SubjectFactoryRegistry.class);
    private Jdbi jdbi;
    HashMap<String, SubjectFactory> registry = new HashMap();

    public void setJDBI(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    public void addSubjectFactory(String type, SubjectFactory factory) {
        if (this.registry.containsKey(type)) {
            this.logger.warn("Overwriting factory " + String.valueOf(this.registry.get(type)) + " for " + type + " with " + String.valueOf(factory));
        }
        this.registry.put(type, factory);
    }

    public void addSubjectFactory(SubjectFactory factory) {
        this.addSubjectFactory(factory.getType(), factory);
    }

    public SubjectFactory getFactoryForType(String type) {
        if (!this.registry.containsKey(type)) {
            this.logger.warn("No factory found for type " + type);
        }
        SubjectFactory factory = this.registry.get(type);
        return factory;
    }

    public boolean isSupported(SubjectDTO dto) {
        String type = dto.getType();
        if (type == null) {
            return false;
        }
        SubjectFactory factory = this.getFactoryForType(type);
        return factory != null;
    }

    public Subject getByDTO(SubjectDTO dto) {
        String type = dto.getType();
        if (type == null) {
            throw new RuntimeException("type can not be null");
        }
        SubjectFactory factory = this.getFactoryForType(type);
        if (factory == null) {
            throw new RuntimeException("No factory found for type " + type);
        }
        Subject subject = factory.getByDTO(dto);
        return subject;
    }

    public <T extends Subject> T getByDTO(SubjectDTO dto, Class<T> type) {
        Subject subject = this.getByDTO(dto);
        return (T)((Subject)type.cast(subject));
    }

    public <T extends Subject> T getById(Long id, Class<T> type) {
        SubjectDTO dto;
        try (Handle handle = this.jdbi.open();){
            SubjectDAO dao = (SubjectDAO)handle.attach(SubjectDAO.class);
            dto = dao.getSubject(id.longValue());
        }
        if (dto == null) {
            throw new RuntimeException("Subject with id " + id + " not found");
        }
        Subject subject = this.getByDTO(dto);
        return (T)((Subject)type.cast(subject));
    }

    public <T extends Subject> T getByName(String name, String type, Class<T> clazz) {
        SubjectDTO dto;
        try (Handle handle = this.jdbi.open();){
            SubjectDAO dao = (SubjectDAO)handle.attach(SubjectDAO.class);
            dto = dao.getSubject(type, name);
        }
        if (dto == null) {
            throw new RuntimeException("Subject with name " + name + " and type " + type + " not found");
        }
        Subject subject = this.getByDTO(dto);
        return (T)((Subject)clazz.cast(subject));
    }
}

