/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.enums;

public enum DomainAuthMethod {
    WHOIS("3.2.2.4.1"),
    DOMAIN_CONTACT_EMAIL_SOA("3.2.2.4.2-SOA"),
    DOMAIN_CONTACT_EMAIL_WHOIS("3.2.2.4.2-Whois"),
    CONSTRUCTED_EMAIL("3.2.2.4.4"),
    DOMAIN_AUTH_LETTER("3.2.2.4.5");

    private final String value;

    private DomainAuthMethod(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String getDescription() {
        return DomainAuthMethod.getDescription(this);
    }

    public static String getDescription(DomainAuthMethod method) {
        if (method == null) {
            return null;
        }
        switch (method) {
            case WHOIS: {
                return "1-whois";
            }
            case DOMAIN_CONTACT_EMAIL_SOA: {
                return "2-Domain-Contact-Mail-SOA";
            }
            case DOMAIN_CONTACT_EMAIL_WHOIS: {
                return "2-Domain-Contact-Mail-Whois";
            }
            case CONSTRUCTED_EMAIL: {
                return "4-Constructed-Mail";
            }
            case DOMAIN_AUTH_LETTER: {
                return "5-DAS";
            }
        }
        return null;
    }

    public static DomainAuthMethod getMethodFromDescString(String description) {
        if (description == null) {
            return null;
        }
        if (description.equalsIgnoreCase(DomainAuthMethod.getDescription(WHOIS))) {
            return WHOIS;
        }
        if (description.equalsIgnoreCase(DomainAuthMethod.getDescription(DOMAIN_CONTACT_EMAIL_SOA))) {
            return DOMAIN_CONTACT_EMAIL_SOA;
        }
        if (description.equalsIgnoreCase(DomainAuthMethod.getDescription(DOMAIN_CONTACT_EMAIL_WHOIS))) {
            return DOMAIN_CONTACT_EMAIL_WHOIS;
        }
        if (description.equalsIgnoreCase(DomainAuthMethod.getDescription(CONSTRUCTED_EMAIL))) {
            return CONSTRUCTED_EMAIL;
        }
        if (description.equalsIgnoreCase(DomainAuthMethod.getDescription(DOMAIN_AUTH_LETTER))) {
            return DOMAIN_AUTH_LETTER;
        }
        return null;
    }

    public static DomainAuthMethod getMethodFromString(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase(WHOIS.getValue())) {
            return WHOIS;
        }
        if (value.equalsIgnoreCase(DOMAIN_CONTACT_EMAIL_SOA.getValue())) {
            return DOMAIN_CONTACT_EMAIL_SOA;
        }
        if (value.equalsIgnoreCase(DOMAIN_CONTACT_EMAIL_WHOIS.getValue())) {
            return DOMAIN_CONTACT_EMAIL_WHOIS;
        }
        if (value.equalsIgnoreCase(CONSTRUCTED_EMAIL.getValue())) {
            return CONSTRUCTED_EMAIL;
        }
        if (value.equalsIgnoreCase(DOMAIN_AUTH_LETTER.getValue())) {
            return DOMAIN_AUTH_LETTER;
        }
        return null;
    }

    public static String getDescriptionFromString(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase(WHOIS.getValue())) {
            return DomainAuthMethod.getDescription(WHOIS);
        }
        if (value.equalsIgnoreCase(DOMAIN_CONTACT_EMAIL_SOA.getValue())) {
            return DomainAuthMethod.getDescription(DOMAIN_CONTACT_EMAIL_SOA);
        }
        if (value.equalsIgnoreCase(DOMAIN_CONTACT_EMAIL_WHOIS.getValue())) {
            return DomainAuthMethod.getDescription(DOMAIN_CONTACT_EMAIL_WHOIS);
        }
        if (value.equalsIgnoreCase(CONSTRUCTED_EMAIL.getValue())) {
            return DomainAuthMethod.getDescription(CONSTRUCTED_EMAIL);
        }
        if (value.equalsIgnoreCase(DOMAIN_AUTH_LETTER.getValue())) {
            return DomainAuthMethod.getDescription(DOMAIN_AUTH_LETTER);
        }
        return null;
    }
}

