/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.tools;

import de.dfncert.soap.DFNCERTDomains;
import de.dfncert.soap.DFNCERTPublic;
import de.dfncert.soap.DFNCERTRegistration;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509KeyManager;

public class DFNPKIClient {
    public static final String PKCS11_PROVIDER_NAME = "SunPKCS11-DFNPKIClient";
    private String publicHost = "pki.pca.dfn.de";
    private String raHost = "ra.pca.dfn.de";
    private String CAName;
    private String storeAlias;
    private PrivateKey RAPrivateKey;
    private X509Certificate[] RAChain;
    private X509Certificate RACertificate;
    private SSLSocketFactory socketFactory;
    private DFNCERTPublic Public = new DFNCERTPublic();
    private DFNCERTDomains Domains = new DFNCERTDomains();
    private DFNCERTRegistration Registration = new DFNCERTRegistration();
    private KeyStore store;

    public DFNPKIClient(String CAName) throws Exception {
        this.initSSL();
        this.setCAName(CAName);
    }

    public DFNCERTPublic getPublic() {
        return this.Public;
    }

    public DFNCERTDomains getDomains() {
        return this.Domains;
    }

    public DFNCERTRegistration getRegistration() {
        return this.Registration;
    }

    public String getCAName() {
        return this.CAName;
    }

    public void setCAName(String CAName) {
        this.CAName = CAName;
        this.setEndpoints();
    }

    public void setPublicHostname(String Hostname) {
        if (Hostname == null) {
            throw new IllegalArgumentException();
        }
        this.publicHost = Hostname;
        this.setEndpoints();
    }

    public void setRAHostname(String Hostname) {
        if (Hostname == null) {
            throw new IllegalArgumentException();
        }
        this.raHost = Hostname;
        this.setEndpoints();
    }

    public void setCheckRevocation(boolean bCheckRevocation) {
        if (bCheckRevocation) {
            System.setProperty("com.sun.net.ssl.checkRevocation", "true");
        } else {
            System.setProperty("com.sun.net.ssl.checkRevocation", "false");
        }
    }

    public X509Certificate getRACertificate() {
        return this.RACertificate;
    }

    public X509Certificate[] getRAChain() {
        return this.RAChain;
    }

    public PrivateKey getRAPrivateKey() {
        return this.RAPrivateKey;
    }

    public SSLSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void loadRAFromKeystore(KeyStore store, String alias, char[] password) throws Exception {
        if (store == null) {
            throw new IllegalArgumentException();
        }
        this.initRACertificate(store, alias, password);
        this.initSSL();
    }

    public void loadRAFromPKCS12(String filename, char[] password) throws Exception {
        FileInputStream input = new FileInputStream(filename);
        this.initKeyStore("PKCS12", "SunJSSE", input, password, null);
        this.initSSL();
    }

    public void loadRAFromPKCS12(InputStream input, char[] password) throws Exception {
        this.initKeyStore("PKCS12", "SunJSSE", input, password, null);
        this.initSSL();
    }

    public void loadRAFromProvider(String providerType, String providerName, String entryName, char[] password) throws Exception {
        this.initKeyStore(providerType, providerName, null, password, entryName);
        this.initSSL();
    }

    public void loadRAFromSmartCard(String pkcs11library, char[] password, String entryName) throws Exception {
        this.loadRAFromSmartCard(pkcs11library, password, entryName, -1);
    }

    public void loadRAFromSmartCard(String pkcs11library, char[] password, String entryName, int slot) throws Exception {
        this.initPKCS11Proivder(pkcs11library, slot);
        this.initKeyStore("PKCS11", PKCS11_PROVIDER_NAME, null, password, entryName);
        this.initSSL();
    }

    public Vector<String> listCertsWithKeyFromSmartCard(String pkcs11library, char[] password) throws Exception {
        this.initPKCS11Proivder(pkcs11library, -1);
        KeyStore tmpStore = KeyStore.getInstance("PKCS11");
        Vector<String> aliases = new Vector<String>();
        tmpStore.load(null, password);
        Enumeration<String> enumAliases = tmpStore.aliases();
        while (enumAliases.hasMoreElements()) {
            String alias = enumAliases.nextElement();
            if (!tmpStore.isKeyEntry(alias)) continue;
            aliases.add(alias);
        }
        return aliases;
    }

    private void setEndpoints() {
        try {
            String pub = String.format("https://%s/%s/cgi-bin/pub/soap/DFNCERT/", this.publicHost, this.CAName);
            String ra = String.format("https://%s/%s/cgi-bin/ra/soap/DFNCERT/", this.raHost, this.CAName);
            this.Public.getSOAPClient().setEndpoint(new URL(String.valueOf(pub) + "Public"));
            this.Domains.getSOAPClient().setEndpoint(new URL(String.valueOf(ra) + "Domains"));
            this.Registration.getSOAPClient().setEndpoint(new URL(String.valueOf(ra) + "Registration"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Bad URL");
        }
    }

    private void initPKCS11Proivder(String pkcs11library, int slot) throws Exception {
        if (Security.getProvider(PKCS11_PROVIDER_NAME) == null) {
            String conf = "name=DFNPKIClient\nlibrary=" + pkcs11library + "\n";
            if (slot > -1) {
                conf = String.valueOf(conf) + "slot=" + slot + "\n";
            }
            Provider pkcs11 = Security.getProvider("SunPKCS11");
            File configFile = File.createTempFile("pkcs11", ".cfg");
            configFile.deleteOnExit();
            Throwable throwable = null;
            Object var7_8 = null;
            try (PrintWriter out = new PrintWriter(configFile);){
                out.println(conf);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            pkcs11 = pkcs11.configure(configFile.getAbsolutePath());
            Security.addProvider(pkcs11);
        }
    }

    private void initKeyStore(String providerType, String providerName, InputStream input, char[] password, String entryName) throws Exception {
        this.store = providerName != null ? KeyStore.getInstance(providerType, providerName) : KeyStore.getInstance(providerType);
        this.store.load(input, password);
        this.storeAlias = entryName;
        Enumeration<String> aliases = this.store.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!this.store.isKeyEntry(alias) || entryName != null && !alias.equals(entryName)) continue;
            this.initRACertificate(this.store, alias, password);
            return;
        }
        throw new Exception("Key entry not found: " + entryName);
    }

    private void initRACertificate(KeyStore store, String alias, char[] password) throws Exception {
        this.store = store;
        this.storeAlias = alias;
        this.RAPrivateKey = (PrivateKey)store.getKey(alias, password);
        this.RACertificate = (X509Certificate)store.getCertificate(alias);
        this.RACertificate.checkValidity();
        Certificate[] chain = store.getCertificateChain(alias);
        if (chain.length == 1) {
            throw new Exception("Certificate chain missing.");
        }
        this.RAChain = new X509Certificate[chain.length];
        int i = 0;
        while (i < chain.length) {
            this.RAChain[i] = (X509Certificate)chain[i];
            ++i;
        }
        this.storeAlias = alias;
    }

    private void initSSL() throws Exception {
        KeyManager[] keyManagers = null;
        if (this.store != null) {
            keyManagers = new KeyManager[]{new MyKeyManager()};
        }
        SSLContext sc = SSLContext.getInstance("TLSv1.2");
        sc.init(keyManagers, null, SecureRandom.getInstance("SHA1PRNG"));
        Security.setProperty("ocsp.enable", "true");
        System.setProperty("com.sun.security.enableCRLDP", "true");
        this.socketFactory = sc.getSocketFactory();
        this.Public.getSOAPClient().setSSLSocketFactory(this.socketFactory);
        this.Domains.getSOAPClient().setSSLSocketFactory(this.socketFactory);
        this.Registration.getSOAPClient().setSSLSocketFactory(this.socketFactory);
    }

    private class MyKeyManager
    implements X509KeyManager {
        private MyKeyManager() {
        }

        @Override
        public String[] getClientAliases(String string, Principal[] prncpls) {
            return new String[]{DFNPKIClient.this.storeAlias};
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] prncpls, Socket socket) {
            return DFNPKIClient.this.storeAlias;
        }

        @Override
        public String[] getServerAliases(String string, Principal[] prncpls) {
            return null;
        }

        @Override
        public String chooseServerAlias(String string, Principal[] prncpls, Socket socket) {
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String string) {
            return DFNPKIClient.this.RAChain;
        }

        @Override
        public PrivateKey getPrivateKey(String string) {
            return DFNPKIClient.this.RAPrivateKey;
        }
    }
}

