/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.validators;

import de.dfncert.enums.EmailLocation;
import de.dfncert.enums.EmailState;
import java.util.Date;
import java.util.Objects;

public class Email {
    private final String local;
    private final String domain;
    private EmailState state;
    private final Long requestSerial;
    private EmailLocation location;
    private Date lastSentDate;
    private Date stateChangeDate;

    public Email() {
        this.local = null;
        this.domain = null;
        this.requestSerial = null;
    }

    public Email(String local, String domain, EmailState state, Long requestSerial, EmailLocation location, Date lastSentDate, Date stateChangeDate) {
        this.local = local;
        this.domain = domain;
        this.state = state;
        this.requestSerial = requestSerial;
        this.location = location;
        this.lastSentDate = lastSentDate;
        this.stateChangeDate = stateChangeDate;
    }

    public Email(String email, EmailState state, Long requestSerial, EmailLocation location, Date lastSentDate, Date stateChangeDate) {
        this(email != null ? (email.indexOf("@") > 0 ? email.substring(0, email.indexOf("@")) : null) : null, email != null ? (email.indexOf("@") > 0 ? email.substring(email.indexOf("@") + 1) : null) : null, state, requestSerial, location, lastSentDate, stateChangeDate);
        if (this.local == null || this.domain == null) {
            throw new IllegalArgumentException("Es wurde keine korrekte E-Mail-Adresse \u00fcbergeben");
        }
    }

    public void confirm() {
        if (this.state != EmailState.PENDING) {
            throw new IllegalStateException("E-Mail-Adressen k\u00f6nnen nur aus dem Status PENDING freigeschaltet werden");
        }
        this.state = EmailState.CONFIRMED;
        this.stateChangeDate = new Date();
    }

    public void reject() {
        if (this.state != EmailState.PENDING) {
            throw new IllegalStateException("E-Mail-Adressen k\u00f6nnen nur aus dem Status PENDING gesperrt werden");
        }
        this.state = EmailState.REJECTED;
        this.stateChangeDate = new Date();
    }

    public void setWhitelisted() {
        if (this.state != EmailState.PENDING) {
            throw new IllegalStateException("E-Mail-Adressen k\u00f6nnen nur aus dem Status PENDING auf WHITELISTED gesetzt werden.");
        }
        this.state = EmailState.WHITELISTED;
        this.stateChangeDate = new Date();
    }

    public void setPending() {
        if (this.state != EmailState.WHITELISTED) {
            throw new IllegalStateException("E-Mail-Adressen k\u00f6nnen nur aus dem Status WHITELISTED auf PENDING gesetzt werden.");
        }
        this.state = EmailState.PENDING;
        this.stateChangeDate = new Date();
    }

    public void setState(EmailState newState) {
        if (newState == EmailState.WHITELISTED) {
            this.setWhitelisted();
        } else if (newState == EmailState.PENDING) {
            this.setPending();
        } else {
            throw new IllegalStateException("E-Mail-Adresse kann nicht auf den State " + newState.getHumanReadable() + " gesetzt werden.");
        }
    }

    public void setLastSentDate(Date lastSentDate) {
        this.lastSentDate = lastSentDate;
    }

    public void setLastSentDate() {
        this.setLastSentDate(new Date());
    }

    public void setLocation(EmailLocation location) {
        this.location = location;
    }

    public String toString() {
        return this.local + "@" + this.domain;
    }

    public boolean isApprovable() {
        return this.state.isApprovable();
    }

    public EmailState getState() {
        return this.state;
    }

    public String getLocal() {
        return this.local;
    }

    public String getDomain() {
        return this.domain;
    }

    public Long getRequestSerial() {
        return this.requestSerial;
    }

    public EmailLocation getLocation() {
        return this.location;
    }

    public Date getLastSentDate() {
        return this.lastSentDate;
    }

    public Date getStateChangeDate() {
        return this.stateChangeDate;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.local);
        hash = 47 * hash + Objects.hashCode(this.domain);
        hash = 47 * hash + Objects.hashCode((Object)this.state);
        hash = 47 * hash + Objects.hashCode(this.requestSerial);
        hash = 47 * hash + Objects.hashCode((Object)this.location);
        hash = 47 * hash + Objects.hashCode(this.lastSentDate);
        hash = 47 * hash + Objects.hashCode(this.stateChangeDate);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Email other = (Email)obj;
        if (!Objects.equals(this.local, other.local)) {
            return false;
        }
        if (!Objects.equals(this.domain, other.domain)) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        if (this.requestSerial != other.requestSerial) {
            return false;
        }
        if (this.location != other.location) {
            return false;
        }
        if (!Objects.equals(this.lastSentDate, other.lastSentDate)) {
            return false;
        }
        return Objects.equals(this.stateChangeDate, other.stateChangeDate);
    }
}

