/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.enums;

import de.dfncert.errors.ConfigurationException;

public enum Policy {
    GLOBAL("Global"),
    COMMUNITY("Community"),
    GRID("Grid");

    private final String name;

    private Policy(String policyName) {
        this.name = policyName;
    }

    public String getValue() {
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Policy getPolicyFromString(String policyName) throws ConfigurationException {
        Policy policy = null;
        if (policyName == null) throw new ConfigurationException("Unknown policy name '" + policyName + "'");
        if (policyName.equalsIgnoreCase("Grid")) {
            return GRID;
        }
        if (policyName.equalsIgnoreCase("Community")) {
            return COMMUNITY;
        }
        if (!policyName.equalsIgnoreCase("Global")) throw new ConfigurationException("Unknown policy name '" + policyName + "'");
        return GLOBAL;
    }
}

