/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.cvc;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openscdp.pkidm.cvc.CryptoProvider;
import org.openscdp.pkidm.cvc.CryptoProviderException;

public class BCCryptoProvider
implements CryptoProvider {
    private BouncyCastleProvider provider;

    public BCCryptoProvider(BouncyCastleProvider bc) {
        this.provider = bc;
    }

    @Override
    public Provider getProvider() {
        return this.provider;
    }

    @Override
    public KeyPair generateKeyPair(AlgorithmParameterSpec params, String alias) throws CryptoProviderException {
        try {
            KeyPairGenerator keyGen = params instanceof ECGenParameterSpec ? KeyPairGenerator.getInstance("EC", (Provider)this.provider) : KeyPairGenerator.getInstance("RSA", (Provider)this.provider);
            keyGen.initialize(params);
            KeyPair kp = keyGen.generateKeyPair();
            return kp;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new CryptoProviderException("generate key pair failed with", e);
        }
    }

    @Override
    public PrivateKey getPrivateKey(byte[] keyId, byte[] keyDomain, byte[] keyblob) throws CryptoProviderException {
        throw new RuntimeException("Not implemented");
    }
}

