/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.util;

public class HexString {
    protected static final String[] hexChars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};

    public static String dump(byte[] data) {
        return HexString.dump(data, 0, data.length);
    }

    public static String dump(byte[] data, int offset, int len) {
        if (data == null) {
            return "null";
        }
        char[] ascii = new char[16];
        StringBuffer out = new StringBuffer(256);
        if (offset + len > data.length) {
            len = data.length - offset;
        }
        int i = offset;
        while (i < offset + len) {
            out.append(HexString.hexify(i >>> 8 & 0xFF));
            out.append(HexString.hexify(i & 0xFF));
            out.append(":  ");
            int j = 0;
            while (j < 16) {
                if (i < offset + len) {
                    int b = data[i] & 0xFF;
                    out.append(HexString.hexify(b)).append(' ');
                    ascii[j] = b >= 32 && b < 127 ? (int)b : 46;
                } else {
                    out.append("   ");
                    ascii[j] = 32;
                }
                ++j;
                ++i;
            }
            out.append(' ').append(ascii).append("\n");
        }
        return out.toString();
    }

    public static String hexify(byte[] data) {
        if (data == null) {
            return "null";
        }
        StringBuffer out = new StringBuffer(256);
        int n = 0;
        for (int i = 0; i < data.length; ++i) {
            if (n > 0) {
                out.append(' ');
            }
            out.append(hexChars[data[i] >> 4 & 0xF]);
            out.append(hexChars[data[i] & 0xF]);
            if (++n != 16) continue;
            out.append('\n');
            n = 0;
        }
        return out.toString();
    }

    public static String hexify(int val) {
        return hexChars[(val & 0xFF & 0xF0) >>> 4] + hexChars[val & 0xF];
    }

    public static String hexifyShort(byte a, byte b) {
        return HexString.hexifyShort(a & 0xFF, b & 0xFF);
    }

    public static String hexifyShort(int val) {
        return hexChars[(val & 0xFFFF & 0xF000) >>> 12] + hexChars[(val & 0xFFF & 0xF00) >>> 8] + hexChars[(val & 0xFF & 0xF0) >>> 4] + hexChars[val & 0xF];
    }

    public static String hexifyShort(int a, int b) {
        return HexString.hexifyShort(((a & 0xFF) << 8) + (b & 0xFF));
    }

    public static byte[] parseHexString(String byteString) {
        byte[] result = new byte[byteString.length() / 2];
        for (int i = 0; i < byteString.length(); i += 2) {
            String toParse = byteString.substring(i, i + 2);
            result[i / 2] = (byte)Integer.parseInt(toParse, 16);
        }
        return result;
    }

    public static byte[] parseLittleEndianHexString(String byteString) {
        byte[] result = new byte[byteString.length() / 2 + 1];
        for (int i = 0; i < byteString.length(); i += 2) {
            String toParse = byteString.substring(i, i + 2);
            result[(byteString.length() - i) / 2] = (byte)Integer.parseInt(toParse, 16);
        }
        result[0] = 0;
        return result;
    }
}

