/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.security;

import de.cardcontact.opencard.security.GPSecureChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import opencard.core.service.CardServiceInvalidParameterException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class GPSCP02SecureChannel
implements GPSecureChannel {
    public static final byte THREE_SECURE_CHANNEL_BASE_KEYS = 1;
    public static final byte CMAC_ON_MODIFIED_APDU = 0;
    public static final byte INITIATION_MODE_EXPLICIT = 4;
    public static final byte ICV_SET_TO_ZERO = 0;
    public static final byte ICV_ENCRYPTION_FOR_CMAC_SESSION = 16;
    public static final byte NO_RMAC_SUPPORT = 0;
    public static final byte WELL_KNOWN_PSEUDO_RANDOM_ALGORITHM = 64;
    public static final byte UNSPECIFIED_CARD_CHALLENGE_GENERATION = 0;
    public static final byte NONE = 0;
    public static final byte C_MAC = 1;
    public static final byte C_MAC_AND_C_ENC = 3;
    protected String provider;
    private Key senc;
    private Key smac;
    private Key dek;
    private byte[] iv = new byte[8];
    private byte securitylevel = 0;
    private Mac mac = null;
    private Cipher singleDES = null;
    private Cipher tripleDES = null;
    private Cipher tripleDESECB = null;
    private static final byte[] ZERO_ICV = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] ISO_PADDING = new byte[]{-128, 0, 0, 0, 0, 0, 0, 0};

    public GPSCP02SecureChannel(Key senc, Key smac, Key dek, byte[] iv, byte securityLevel, String provider) {
        this.provider = provider;
        this.senc = senc;
        this.smac = smac;
        this.dek = dek;
        this.securitylevel = securityLevel;
        System.arraycopy(iv, 0, this.iv, 0, 8);
        try {
            this.mac = Mac.getInstance("ISO9797ALG3Mac", provider);
            this.singleDES = Cipher.getInstance("DES/CBC/NoPadding", provider);
            this.tripleDES = Cipher.getInstance("DESede/CBC/NoPadding", provider);
            this.tripleDESECB = Cipher.getInstance("DESede/ECB/NoPadding", provider);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to obtain crypto instance", e);
        }
    }

    @Override
    public ResponseAPDU unwrap(ResponseAPDU apduToUnwrap, int usageQualifier) {
        return apduToUnwrap;
    }

    @Override
    public CommandAPDU wrap(CommandAPDU apduToWrap, int usageQualifier) {
        int paddingRequired;
        if (this.securitylevel == 0) {
            return apduToWrap;
        }
        if (apduToWrap.getLength() >= 248) {
            throw new CardServiceInvalidParameterException("Length of C-Data must not exceed 247 in C_MAC mode");
        }
        byte[] raw_apdu = apduToWrap.getBytes();
        byte le = -1;
        int lc = 0;
        if (raw_apdu.length != 4) {
            if (raw_apdu.length == 5) {
                le = raw_apdu[4];
            } else if (raw_apdu.length >= 6 && raw_apdu.length - (lc = (int)((short)(raw_apdu[4] & 0xFF))) - 4 > 0) {
                le = raw_apdu[raw_apdu.length - 1];
            }
        }
        if ((paddingRequired = 8 - (5 + lc) % 8) == 0) {
            paddingRequired = 8;
        }
        byte[] patched_apdu = new byte[5 + lc + paddingRequired];
        patched_apdu[0] = (byte)(raw_apdu[0] | 4);
        patched_apdu[1] = raw_apdu[1];
        patched_apdu[2] = raw_apdu[2];
        patched_apdu[3] = raw_apdu[3];
        patched_apdu[4] = (byte)(lc + 8);
        if (lc > 0) {
            System.arraycopy(raw_apdu, 5, patched_apdu, 5, lc);
            System.arraycopy(ISO_PADDING, 0, patched_apdu, 5 + lc, paddingRequired);
        } else {
            System.arraycopy(ISO_PADDING, 0, patched_apdu, 5, paddingRequired);
        }
        try {
            byte[] sessionSMACvalue = new byte[8];
            System.arraycopy(this.smac.getEncoded(), 0, sessionSMACvalue, 0, 8);
            SecretKeySpec keySpec = new SecretKeySpec(sessionSMACvalue, "DES");
            this.singleDES.init(1, (Key)keySpec, new IvParameterSpec(ZERO_ICV));
            byte[] enc_icv = this.singleDES.doFinal(this.iv);
            this.mac.init(this.smac, new IvParameterSpec(enc_icv));
            this.iv = this.mac.doFinal(patched_apdu);
        }
        catch (InvalidKeyException e) {
            throw new CardServiceInvalidParameterException("Wrong key for MAC calculation : " + e.getLocalizedMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CardServiceInvalidParameterException("Invalid algorithm parameter for MAC calculation : " + e.getLocalizedMessage());
        }
        catch (IllegalStateException e) {
            throw new CardServiceInvalidParameterException("Illegal state for MAC calculation : " + e.getLocalizedMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new CardServiceInvalidParameterException("Illegal block size for MAC calculation : " + e.getLocalizedMessage());
        }
        catch (BadPaddingException e) {
            throw new CardServiceInvalidParameterException("Bad padding for MAC calculation : " + e.getLocalizedMessage());
        }
        CommandAPDU patchedApdu = new CommandAPDU(262);
        patchedApdu.setQueueable(apduToWrap.isQueueable());
        byte[] apdu = new byte[5];
        System.arraycopy(patched_apdu, 0, apdu, 0, 5);
        if (this.securitylevel == 3) {
            if (lc > 0) {
                if (lc >= 240) {
                    throw new CardServiceInvalidParameterException("Length of C-Data must not exceed 239 in C_MAC_AND_C_ENC mode");
                }
                try {
                    paddingRequired = 8 - lc % 8;
                    if (paddingRequired == 0) {
                        paddingRequired = 8;
                    }
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    this.tripleDES.init(1, this.senc, new IvParameterSpec(ZERO_ICV));
                    byte[] r = this.tripleDES.update(raw_apdu, 5, lc);
                    if (r != null) {
                        bos.write(r);
                    }
                    if ((r = this.tripleDES.update(ISO_PADDING, 0, paddingRequired)) != null) {
                        bos.write(r);
                    }
                    if ((r = this.tripleDES.doFinal()) != null) {
                        bos.write(r);
                    }
                    byte[] encryptedData = bos.toByteArray();
                    apdu[4] = (byte)(encryptedData.length + 8);
                    patchedApdu.append(apdu);
                    patchedApdu.append(encryptedData);
                }
                catch (InvalidKeyException e) {
                    throw new CardServiceInvalidParameterException("Wrong key for ENC : " + e.getLocalizedMessage());
                }
                catch (IllegalBlockSizeException e) {
                    throw new CardServiceInvalidParameterException("Illegal block size for ENC : " + e.getLocalizedMessage());
                }
                catch (BadPaddingException e) {
                    throw new CardServiceInvalidParameterException("Bad padding for ENC : " + e.getLocalizedMessage());
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new CardServiceInvalidParameterException("Invalid algorithm parameter for ENC : " + e.getLocalizedMessage());
                }
                catch (IOException e) {
                    throw new CardServiceInvalidParameterException("I/O error during encryption : " + e.getLocalizedMessage());
                }
            } else {
                patchedApdu.append(apdu);
            }
        } else {
            patchedApdu.append(apdu);
            if (lc > 0) {
                byte[] data = new byte[lc];
                System.arraycopy(raw_apdu, 5, data, 0, lc);
                patchedApdu.append(data);
            }
        }
        patchedApdu.append(this.iv);
        if (le != -1) {
            patchedApdu.append(le);
        }
        return patchedApdu;
    }

    @Override
    public byte[] encryptKey(SecretKey key) {
        byte[] result = new byte[22];
        try {
            this.tripleDESECB.init(1, key);
            byte[] kcv = this.tripleDESECB.doFinal(ZERO_ICV);
            this.tripleDESECB.init(1, this.dek);
            byte[] cryptogram = this.tripleDESECB.doFinal(key.getEncoded());
            result[0] = -128;
            result[1] = 16;
            System.arraycopy(cryptogram, 0, result, 2, 16);
            result[18] = 3;
            System.arraycopy(kcv, 0, result, 19, 3);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to prepare cryptogram", e);
        }
        return result;
    }

    public static boolean scpOptionsSupported(byte options) {
        return options == 21 || options == 85;
    }
}

