/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.security;

import de.cardcontact.opencard.security.AESKeyDerivationBase;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public class AESKeyDerivation
extends AESKeyDerivationBase {
    private Mac aesCMAC;
    private SecretKey key;

    public AESKeyDerivation(SecretKey key) {
        this.key = key;
        this.keysize = key.getEncoded().length;
        try {
            this.aesCMAC = Mac.getInstance("AESCMAC");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create cipher instance", e);
        }
    }

    @Override
    protected byte[] calculateMAC(byte[] input) {
        try {
            this.aesCMAC.init(this.key);
            return this.aesCMAC.doFinal(input);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate MAC", e);
        }
    }
}

