/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.soap;

import de.dfncert.enums.RevocationReason;
import de.dfncert.slight.SOAPClient;
import de.dfncert.soap.DFNCERTTypesCAInfo;
import de.dfncert.soap.DFNCERTTypesCAStatus;
import de.dfncert.soap.DFNCERTTypesCertificateInfo;
import de.dfncert.soap.DFNCERTTypesExtendedObjectInfo;
import de.dfncert.soap.DFNCERTTypesExtendedRequestInfo;
import de.dfncert.soap.DFNCERTTypesExtendedRequestParameters;
import de.dfncert.soap.DFNCERTTypesExtendedRevocationInfo;
import de.dfncert.soap.DFNCERTTypesObjectInfo;
import de.dfncert.soap.DFNCERTTypesRenewRequestResult;
import de.dfncert.soap.DFNCERTTypesRequestData;
import de.dfncert.soap.DFNCERTTypesRequestInfo;
import de.dfncert.soap.DFNCERTTypesRequestParameters;
import de.dfncert.soap.DFNCERTTypesRevocationInfo;
import de.dfncert.soap.DFNCERTTypesRevocationParameters;
import de.dfncert.validators.Email;
import java.math.BigInteger;
import java.util.Collection;

public class DFNCERTRegistration {
    private SOAPClient client = new SOAPClient("https://ra.pca.dfn.de/DFNCERT/Registration", "de.dfncert.soap");

    public SOAPClient getSOAPClient() {
        return this.client;
    }

    public DFNCERTTypesCAStatus getCAStatus() throws Exception {
        String[] paramNames = new String[]{};
        Object[] paramValues = new Object[]{};
        return (DFNCERTTypesCAStatus)this.client.doRequest("getCAStatus", paramNames, paramValues);
    }

    public DFNCERTTypesCAInfo getCAInfo() throws Exception {
        String[] paramNames = new String[]{};
        Object[] paramValues = new Object[]{};
        return (DFNCERTTypesCAInfo)this.client.doRequest("getCAInfo", paramNames, paramValues);
    }

    @Deprecated
    public DFNCERTTypesObjectInfo[] searchItems(String Type2, String Status, int Offset, int Limit) throws Exception {
        String[] paramNames = new String[]{"Type", "Status", "Offset", "Limit"};
        Object[] paramValues = new Object[]{Type2, Status, Offset, Limit};
        return (DFNCERTTypesObjectInfo[])this.client.doRequest("searchItems", paramNames, paramValues);
    }

    public DFNCERTTypesExtendedObjectInfo[] searchItems2(String Type2, String Status, String Role2, Integer RaID, BigInteger LastSerial, int Limit) throws Exception {
        String[] paramNames = new String[]{"Type", "Status", "Role", "DesiredRaID", "LastSerial", "Limit"};
        Object[] paramValues = new Object[]{Type2, Status, Role2, RaID, LastSerial, Limit};
        return (DFNCERTTypesExtendedObjectInfo[])this.client.doRequest("searchItems2", paramNames, paramValues);
    }

    @Deprecated
    public DFNCERTTypesExtendedObjectInfo[] searchExtendedItems(String Type2, String Status, int Offset, int Limit) throws Exception {
        String[] paramNames = new String[]{"Type", "Status", "Offset", "Limit"};
        Object[] paramValues = new Object[]{Type2, Status, Offset, Limit};
        return (DFNCERTTypesExtendedObjectInfo[])this.client.doRequest("searchExtendedItems", paramNames, paramValues);
    }

    @Deprecated
    public DFNCERTTypesExtendedObjectInfo[] searchItemsByRole(String Type2, String Status, String Role2, int Offset, int Limit) throws Exception {
        String[] paramNames = new String[]{"Type", "Status", "Role", "Offset", "Limit"};
        Object[] paramValues = new Object[]{Type2, Status, Role2, Offset, Limit};
        return (DFNCERTTypesExtendedObjectInfo[])this.client.doRequest("searchItemsByRole", paramNames, paramValues);
    }

    @Deprecated
    public DFNCERTTypesExtendedObjectInfo[] searchItemsForRaID(String Type2, String Status, int Offset, int Limit, int DesiredRaID) throws Exception {
        String[] paramNames = new String[]{"Type", "Status", "Offset", "Limit", "DesiredRaID"};
        Object[] paramValues = new Object[]{Type2, Status, Offset, Limit, DesiredRaID};
        return (DFNCERTTypesExtendedObjectInfo[])this.client.doRequest("searchItemsForRaID", paramNames, paramValues);
    }

    public DFNCERTTypesRequestInfo getRequestInfo(int Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (DFNCERTTypesRequestInfo)this.client.doRequest("getRequestInfo", paramNames, paramValues);
    }

    public DFNCERTTypesExtendedRequestInfo getExtendedRequestInfo(int Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (DFNCERTTypesExtendedRequestInfo)this.client.doRequest("getExtendedRequestInfo", paramNames, paramValues);
    }

    public DFNCERTTypesRequestData getRequestData(int Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (DFNCERTTypesRequestData)this.client.doRequest("getRequestData", paramNames, paramValues);
    }

    public byte[] getRequestPrintout(int Serial, String Format) throws Exception {
        String[] paramNames = new String[]{"Serial", "Format"};
        Object[] paramValues = new Object[]{Serial, Format};
        return (byte[])this.client.doRequest("getRequestPrintout", paramNames, paramValues);
    }

    public Boolean setRequestParameters(int Serial, DFNCERTTypesRequestParameters RequestParameters) throws Exception {
        String[] paramNames = new String[]{"Serial", "RequestParameters"};
        Object[] paramValues = new Object[]{Serial, RequestParameters};
        return (Boolean)this.client.doRequest("setRequestParameters", paramNames, paramValues);
    }

    public Boolean setExtendedRequestParameters(int Serial, DFNCERTTypesExtendedRequestParameters RequestParameters) throws Exception {
        String[] paramNames = new String[]{"Serial", "RequestParameters"};
        Object[] paramValues = new Object[]{Serial, RequestParameters};
        return (Boolean)this.client.doRequest("setExtendedRequestParameters", paramNames, paramValues);
    }

    public byte[] getRawRequest(int Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (byte[])this.client.doRequest("getRawRequest", paramNames, paramValues);
    }

    public Boolean approveRequest(int Serial, byte[] Content, String Signature) throws Exception {
        String[] paramNames = new String[]{"Serial", "Content", "Signature"};
        Object[] paramValues = new Object[]{Serial, Content, Signature};
        return (Boolean)this.client.doRequest("approveRequest", paramNames, paramValues);
    }

    public Boolean deleteRequest(int Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (Boolean)this.client.doRequest("deleteRequest", paramNames, paramValues);
    }

    public Integer renewRequest(int Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (Integer)this.client.doRequest("renewRequest", paramNames, paramValues);
    }

    public DFNCERTTypesRenewRequestResult renewRequestSetPublishIfNeeded(int Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (DFNCERTTypesRenewRequestResult)this.client.doRequest("renewRequestSetPublishIfNeeded", paramNames, paramValues);
    }

    @Deprecated
    public Integer newRevocationRequest(BigInteger Serial, String Reason) throws Exception {
        String[] paramNames = new String[]{"Serial", "Reason"};
        Object[] paramValues = new Object[]{Serial, Reason};
        return (Integer)this.client.doRequest("newRevocationRequest", paramNames, paramValues);
    }

    public Integer newRevocationRequest(BigInteger Serial, RevocationReason Reason) throws Exception {
        String[] paramNames = new String[]{"Serial", "Reason"};
        Object[] paramValues = new Object[]{Serial, Reason.getReasonCode()};
        return (Integer)this.client.doRequest("newRevocationRequest", paramNames, paramValues);
    }

    public byte[] getRawRevocationRequest(int Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (byte[])this.client.doRequest("getRawRevocationRequest", paramNames, paramValues);
    }

    public Boolean approveRevocationRequest(int Serial, byte[] Content, String Signature) throws Exception {
        String[] paramNames = new String[]{"Serial", "Content", "Signature"};
        Object[] paramValues = new Object[]{Serial, Content, Signature};
        return (Boolean)this.client.doRequest("approveRevocationRequest", paramNames, paramValues);
    }

    public Boolean deleteRevocationRequest(int Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (Boolean)this.client.doRequest("deleteRevocationRequest", paramNames, paramValues);
    }

    public String getCertificate(BigInteger Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (String)this.client.doRequest("getCertificate", paramNames, paramValues);
    }

    public String getCertificateByRequestSerial(int Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (String)this.client.doRequest("getCertificateByRequestSerial", paramNames, paramValues);
    }

    public DFNCERTTypesCertificateInfo getCertificateInfo(BigInteger Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (DFNCERTTypesCertificateInfo)this.client.doRequest("getCertificateInfo", paramNames, paramValues);
    }

    public DFNCERTTypesRevocationInfo getRevocationInfo(int Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (DFNCERTTypesRevocationInfo)this.client.doRequest("getRevocationInfo", paramNames, paramValues);
    }

    public DFNCERTTypesExtendedRevocationInfo getExtendedRevocationInfo(int Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (DFNCERTTypesExtendedRevocationInfo)this.client.doRequest("getExtendedRevocationInfo", paramNames, paramValues);
    }

    public Boolean setRevocationParameters(int Serial, DFNCERTTypesRevocationParameters Parameters2) throws Exception {
        String[] paramNames = new String[]{"Serial", "Parameters"};
        Object[] paramValues = new Object[]{Serial, Parameters2};
        return (Boolean)this.client.doRequest("setRevocationParameters", paramNames, paramValues);
    }

    public byte[][] getResources(String[] Names) throws Exception {
        String[] paramNames = new String[]{"Names"};
        Object[] paramValues = new Object[]{Names};
        return (byte[][])this.client.doRequest("getResources", paramNames, paramValues);
    }

    public Boolean sendConfirmationEmail(Collection<Email> emails) throws Exception {
        if (emails.isEmpty()) {
            return false;
        }
        String[] EMails = new String[emails.size()];
        int i = 0;
        Long Serial = emails.iterator().next().getRequestSerial();
        for (Email email : emails) {
            assert (email.getRequestSerial().equals(Serial));
            EMails[i] = email.toString();
            ++i;
        }
        String[] paramNames = new String[]{"Serial", "EMails"};
        Object[] paramValues = new Object[]{Serial, EMails};
        return (Boolean)this.client.doRequest("sendConfirmationEMail", paramNames, paramValues);
    }

    public Boolean showLocalDomainWarning(int Serial) throws Exception {
        String[] paramNames = new String[]{"Serial"};
        Object[] paramValues = new Object[]{Serial};
        return (Boolean)this.client.doRequest("showLocalDomainWarning", paramNames, paramValues);
    }
}

