/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.pkcs8;

import de.cardcontact.tlv.IntegerTLV;
import de.cardcontact.tlv.OctetString;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.KeySpec;

public class ECPrivateKeyTLV
extends Sequence {
    static final String NAME = "ECPrivateKey";

    public ECPrivateKeyTLV(TLV tlv) throws TLVEncodingException {
        super(tlv);
        this.setName(NAME);
        if (this.childs.size() != 2) {
            throw new TLVEncodingException("ECPrivateKey must contain 2 elements");
        }
        if (!(this.childs.get(0) instanceof IntegerTLV)) {
            throw new TLVEncodingException("Version must be INTEGER");
        }
        if (!(this.childs.get(1) instanceof OctetString)) {
            throw new TLVEncodingException("Value must be OCTET-STRING");
        }
    }

    public KeySpec getKeySpec(ECParameterSpec specs) {
        return new ECPrivateKeySpec(new BigInteger(1, ((TLV)this.childs.get(1)).getValue()), specs);
    }
}

