/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector.pkidm.action;

import de.dfncert.soap.DFNCERTTypesRequestInfo;
import de.dfncert.tools.DFNPKIClient;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.openscdp.dfn.connector.pkidm.Utils;
import org.openscdp.dfn.connector.pkidm.servicerequest.DFNCertificateRequestBase;
import org.openscdp.dfn.connector.pkidm.signer.RegistrationAuthority;
import org.openscdp.dfn.connector.pkidm.signer.RegistrationAuthorityContent;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.action.ServiceRequestSingleAction;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFNCertRetrievalAction
extends ServiceRequestSingleAction {
    final Logger logger = LoggerFactory.getLogger(DFNCertRetrievalAction.class);
    private static final Set<Integer> productions = ConcurrentHashMap.newKeySet();
    private DFNCertificateRequestBase sr;
    private Long userId;
    private DFNPKIClient client;
    private int serial;
    private int raID;

    public DFNCertRetrievalAction(DFNCertificateRequestBase serviceRequest, Long userId) {
        super((ServiceRequest)serviceRequest);
        this.sr = serviceRequest;
        this.userId = userId;
    }

    protected void executeImpl() {
        this.logger.debug("Start DFNCertRetrievalAction (SR-ID " + this.sr.getId() + ")");
        RegistrationAuthority ra = this.sr.getRA();
        RegistrationAuthorityContent c = ra.getContent();
        try {
            this.client = new DFNPKIClient(ra.getCAName());
            this.serial = this.sr.getCertificateRequestSerialNumber();
            this.raID = c.raID;
            DFNCERTTypesRequestInfo info = this.client.getPublic().getRequestInfo(this.raID, this.serial, this.sr.getPIN());
            if (Utils.isApproved(info)) {
                if (this.sr.getLifeCycle() < 6) {
                    this.sr.setStatusInfo("Certificate approved");
                    this.sr.setLifeCycle(6);
                    this.sr.commit(this.userId, null);
                }
                if (!this.isRetrieving()) {
                    this.retrieveCertificate();
                }
            } else {
                this.sr.setStatusInfo("Certificate not yet approved");
                this.sr.commit(this.userId, null);
            }
        }
        catch (Exception e) {
            throw new ServiceRequestActionException("DFNCertRetrievalAction failed (SR-ID: " + this.sr.getId() + "): " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean isRetrieving() {
        return productions.contains(this.serial);
    }

    private void retrieveCertificate() {
        Thread t = new Thread(() -> {
            try {
                productions.add(this.serial);
                int waitingCounter = 0;
                String pem = "";
                while (pem.equals("")) {
                    block8: {
                        try {
                            if (waitingCounter++ < 100) break block8;
                            this.sr.setStatusInfo("Certificate retrieval timed out");
                            this.sr.setLifeCycle(18);
                            this.sr.commit(this.userId, null);
                            this.logger.debug("Abbort certificate retrival because the maximun numbers of tries have been reached (" + waitingCounter + ")");
                            return;
                        }
                        catch (Exception e) {
                            this.sr.setStatusInfo("Certificate retrieval failed");
                            this.sr.setLifeCycle(18);
                            this.sr.commit(this.userId, null);
                            throw new RuntimeException("Certificate retrieval failed", e);
                        }
                    }
                    this.logger.debug("Waiting for the certificate to be produced (iteration " + waitingCounter + ")");
                    Thread.sleep(15000L);
                    pem = this.client.getPublic().getCertificateByRequestSerial(this.raID, this.serial, this.sr.getPIN());
                }
                this.importCertificate(pem);
            }
            finally {
                productions.remove(this.serial);
            }
        });
        t.start();
    }

    private void importCertificate(String pem) {
        try {
            X509Certificate cert = Utils.toX509Certificate(pem);
            Utils.importCertificate(cert, this.sr.getOriginatorId(), false, this.sr.getId());
        }
        catch (IOException | CertificateException e) {
            this.sr.setStatusInfo("Certificate processing failed");
            this.sr.setLifeCycle(18);
            this.sr.commit(this.userId, null);
            throw new ServiceRequestActionException("Certificate processing failed  (SR-ID: " + this.sr.getId() + "): " + e.getMessage(), (Throwable)e);
        }
        this.sr.setStatusInfo("Certificate issued");
        this.sr.setLifeCycle(7);
        this.sr.setRoleId(null);
        this.sr.commit(this.userId, null);
    }
}

