/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.dfn.connector.pkidm.action;

import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.dfncert.soap.DFNCERTTypesRequestInfo;
import de.dfncert.soap.DFNCERTTypesRequestParameters;
import java.util.Calendar;
import java.util.Date;
import org.openscdp.dfn.connector.pkidm.Utils;
import org.openscdp.dfn.connector.pkidm.action.DFNCertRetrievalAction;
import org.openscdp.dfn.connector.pkidm.action.DFNSignatureAction;
import org.openscdp.dfn.connector.pkidm.servicerequest.DFNCertificateRequestBase;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFNApproveAction
extends DFNSignatureAction {
    final Logger logger = LoggerFactory.getLogger(DFNApproveAction.class);
    private DFNCertificateRequestBase sr;
    private Long userId;
    private int serial;
    private DFNCERTTypesRequestInfo info;

    public DFNApproveAction(DFNCertificateRequestBase serviceRequest, Long userId) {
        super(serviceRequest);
        this.sr = serviceRequest;
        this.userId = userId;
        this.serial = this.sr.getCertificateRequestSerialNumber();
    }

    public void execute(SmartCardHSMProvider provider) {
        this.logger.debug("Start DFNApproveAction (SR-ID " + this.sr.getId() + ")");
        try {
            this.authenticate(provider);
            this.info = this.client.getRegistration().getRequestInfo(this.serial);
            if (Utils.isApproved(this.info)) {
                if (this.sr.getLifeCycle() < 6) {
                    this.sr.setStatusInfo("Certificate approved");
                    this.sr.setLifeCycle(6);
                    this.sr.commit(this.userId, null);
                }
            } else {
                this.updateDN();
                this.approveRequest(provider);
            }
            DFNCertRetrievalAction action = new DFNCertRetrievalAction(this.sr, this.userId);
            action.executeImpl();
        }
        catch (Exception e) {
            throw new ServiceRequestActionException("DFNApproveAction failed (SR-ID: " + this.sr.getId() + "): " + e.getMessage(), (Throwable)e);
        }
    }

    private void updateDN() throws Exception {
        DFNCERTTypesRequestParameters param = this.info.getParameters();
        param.setSubject(this.sr.getSubjectDN());
        this.client.getRegistration().setRequestParameters(this.serial, param);
    }

    public void approveRequest(SmartCardHSMProvider provider) throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.add(6, 1096);
        Date notAfter = cal.getTime();
        DFNCERTTypesRequestParameters param = this.info.getParameters();
        param.setNotAfter(notAfter);
        this.client.getRegistration().setRequestParameters(this.serial, param);
        byte[] raw = this.client.getRegistration().getRawRequest(this.serial);
        String signedRequest = this.signRequest(provider, raw);
        boolean approved = this.client.getRegistration().approveRequest(this.serial, raw, signedRequest);
        if (approved) {
            this.sr.setStatusInfo("Certificate approved");
            this.sr.setLifeCycle(6);
        } else {
            this.sr.setStatusInfo("Certificate approval failed");
        }
        this.sr.commit(this.userId, null);
    }
}

