/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.form;

import de.cardcontact.opencard.service.smartcardhsm.KeyDomain;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.HexString;
import java.util.Arrays;
import java.util.List;
import opencard.core.OpenCardException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.TokenDAO;
import org.openscdp.pkidb.dto.TokenDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.form.OptionGroupValue;
import org.openscdp.pkidm.form.SelectField;
import org.openscdp.pkidm.form.SelectFieldValue;
import org.openscdp.pkidm.form.SelectValue;
import org.openscdp.pkihsmsrv.HSMService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDomainSelectField
extends SelectField {
    private final Logger logger = LoggerFactory.getLogger(KeyDomainSelectField.class);

    protected KeyDomainSelectField(String id, String label, boolean editable) {
        super(id, label, editable, true);
    }

    public KeyDomainSelectField(String id, String label, boolean editable, Long subjectId) {
        super(id, label, editable, true);
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            TokenDAO dao = (TokenDAO)handle.attach(TokenDAO.class);
            List list = dao.getTokenList(subjectId);
            for (TokenDTO token : list) {
                HSMService hsmService = PKIDMContext.getHSMService();
                SmartCardHSMProvider provider = hsmService.getProvider(token.getPath());
                if (provider == null) {
                    this.logger.debug("Token " + token.getPath() + " is not connected");
                    continue;
                }
                OptionGroupValue opt = new OptionGroupValue();
                opt.label = token.getPath();
                SmartCardHSMCardService service = provider.getSmartCardHSMCardService();
                try {
                    this.addKeyDomains(service, opt);
                }
                catch (OpenCardException e) {
                    this.logger.warn("Enumeration of key domains failed for token " + token.getPath(), (Throwable)e);
                    continue;
                }
                this.add(opt);
            }
        }
    }

    protected void addKeyDomains(SmartCardHSMCardService service, OptionGroupValue opt) throws OpenCardException {
        List keyDomains = service.getKeyDomains();
        byte[] defaultKDUID = service.getDefaultKeyDomainUID();
        SelectValue defaultKeyDomainSelectValue = this.createDefaultKeyDomainSelectValue(defaultKDUID);
        int tokenHashCode = (int)defaultKeyDomainSelectValue.id;
        opt.value.add(defaultKeyDomainSelectValue);
        for (KeyDomain kd : keyDomains) {
            if (!kd.isCreated()) continue;
            opt.value.add(this.createKeyDomainSelectValue(tokenHashCode, kd.getKeyDomainUID()));
        }
    }

    protected SelectValue createDefaultKeyDomainSelectValue(byte[] defaultKDUID) {
        int tokenHashCode = Arrays.hashCode(defaultKDUID);
        return new SelectValue(tokenHashCode, "Default (" + HexString.hexifyByteArray((byte[])defaultKDUID, (char)'\u0000', (int)3) + "...)");
    }

    protected SelectValue createKeyDomainSelectValue(byte[] defaultKDUID, byte[] kcvOrUID) {
        int tokenHashCode = Arrays.hashCode(defaultKDUID);
        return this.createKeyDomainSelectValue(tokenHashCode, kcvOrUID);
    }

    protected SelectValue createKeyDomainSelectValue(int tokenHashCode, byte[] kcvOrUID) {
        int kdHashCode = Arrays.hashCode(kcvOrUID);
        return new SelectValue(tokenHashCode + kdHashCode, HexString.hexifyByteArray((byte[])kcvOrUID));
    }

    public String getSelectedToken() {
        for (SelectFieldValue sfv : this.options) {
            OptionGroupValue opt = (OptionGroupValue)sfv;
            SelectValue selectedKeyDomain = null;
            for (SelectValue val : opt.value) {
                if (!val.selected) continue;
                selectedKeyDomain = val;
                break;
            }
            if (selectedKeyDomain == null) continue;
            return opt.label;
        }
        return null;
    }

    public String getSelectedKeyDomain() {
        for (SelectFieldValue sfv : this.options) {
            OptionGroupValue opt = (OptionGroupValue)sfv;
            for (SelectValue val : opt.value) {
                if (!val.selected) continue;
                return val.value;
            }
        }
        return null;
    }
}

