/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.form;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.openscdp.pkidm.form.HasValue;
import org.openscdp.pkidm.form.Setter;
import org.openscdp.pkidm.form.ValueProvider;

public class Binder<T> {
    private Class<T> clazz;
    private ArrayList<Binding<T, ?>> bindings = new ArrayList();

    public Binder(Class<T> clazz) {
        this.clazz = clazz;
    }

    public <F> Binding<T, F> bind(HasValue<F> fld, ValueProvider<T, F> getter, Setter<T, F> setter) {
        Binding<T, F> b = this.forField(fld);
        b.bind(getter, setter);
        return b;
    }

    public <F> Binding<T, F> forField(HasValue<F> fld) {
        Binding b = new Binding(fld);
        this.bindings.add(b);
        return b;
    }

    public void from(T source) {
        this.bindings.forEach((Consumer<Binding<T, ?>>)((Consumer<Binding>)b -> b.setField(source)));
    }

    public void to(T destination) {
        this.bindings.forEach((Consumer<Binding<T, ?>>)((Consumer<Binding>)b -> b.getField(destination)));
    }

    public boolean hasChanged(T destination) {
        boolean hasChanged = false;
        for (Binding<T, ?> b : this.bindings) {
            if (!b.hasChanged(destination)) continue;
            hasChanged = true;
        }
        return hasChanged;
    }

    public class Binding<TT, U> {
        HasValue<U> field;
        ValueProvider<TT, U> getter;
        Setter<TT, U> setter;

        Binding(HasValue<U> field) {
            this.field = field;
        }

        Binding(HasValue<U> field, ValueProvider<TT, U> getter, Setter<TT, U> setter) {
            this.field = field;
            this.getter = getter;
            this.setter = setter;
        }

        public void bind(ValueProvider<TT, U> getter, Setter<TT, U> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public void bind(ValueProvider<TT, U> getter) {
            this.getter = getter;
        }

        void setField(TT source) {
            this.field.setValue(this.getter.apply(source));
        }

        void getField(TT source) {
            this.setter.accept(source, this.field.getValue());
        }

        public boolean hasChanged(TT source) {
            return this.field.getValue() != null && !this.field.getValue().equals(this.getter.apply(source));
        }
    }
}

