/*
 * Decompiled with CFR 0.152.
 */
package de.dfncert.slight;

import de.dfncert.enums.EmailLocation;
import de.dfncert.enums.EmailState;
import de.dfncert.slight.SOAPClient;
import de.dfncert.validators.Email;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RPCDeserializer {
    private final String packageName;

    public RPCDeserializer(String packageName) {
        if (Package.getPackage(packageName) == null) {
            throw new IllegalArgumentException("Could not initialize RPCDeserializer!Found no package named " + packageName);
        }
        this.packageName = packageName;
    }

    private Class getJavaClassForNode(Node node) throws ClassNotFoundException {
        String type = "";
        if (node.getAttributes() != null) {
            Node typeAttr = node.getAttributes().getNamedItem("xsi:type");
            if (typeAttr != null) {
                type = typeAttr.getNodeValue();
            } else {
                String value;
                Node nullAttr = node.getAttributes().getNamedItem("xsi:null");
                if (nullAttr == null) {
                    nullAttr = node.getAttributes().getNamedItem("xsi:nil");
                }
                if (nullAttr != null && ((value = nullAttr.getNodeValue()).equals("1") || value.equals("true"))) {
                    return null;
                }
            }
        }
        if (type.equals("xsd:string")) {
            return String.class;
        }
        if (type.equals("xsd:int")) {
            return Integer.TYPE;
        }
        if (type.equals("xsd:integer")) {
            return BigInteger.class;
        }
        if (type.equals("xsd:long")) {
            return Long.TYPE;
        }
        if (type.equals("xsd:boolean")) {
            return Boolean.TYPE;
        }
        if (type.equals("xsd:dateTime")) {
            return Date.class;
        }
        if (type.equals("xsd:base64Binary")) {
            return byte[].class;
        }
        if (type.equals("EMailLocation")) {
            return EmailLocation.class;
        }
        if (type.equals("EMailState")) {
            return EmailState.class;
        }
        if (type.equals("Email")) {
            return Email.class;
        }
        if (type.equalsIgnoreCase("soap-enc:array") || type.equalsIgnoreCase("soapenc:array") || type.contains(":ArrayOf")) {
            Class arrayClass = this.getJavaClassForArray(node);
            if (arrayClass == null) {
                return null;
            }
            return Array.newInstance(arrayClass, 0).getClass();
        }
        if (type.equals("SOAP-ENC:base64")) {
            return Base64.class;
        }
        type = type.replaceAll("^.*:", "");
        type = type.replaceAll("_", "");
        return Class.forName(String.valueOf(this.packageName) + "." + type);
    }

    private Class getJavaClassForArray(Node node) throws ClassNotFoundException {
        String type;
        Node typeNode = node.getAttributes().getNamedItem("SOAP-ENC:arrayType");
        if (typeNode == null) {
            typeNode = node.getAttributes().getNamedItem("soapenc:arrayType");
        }
        if ((type = typeNode.getNodeValue()).contains("[0]")) {
            return null;
        }
        if (type.startsWith("xsd:string")) {
            return String.class;
        }
        if (type.startsWith("xsd:ur-type")) {
            return String.class;
        }
        if (type.startsWith("xsd:integer")) {
            return BigInteger.class;
        }
        if (type.startsWith("xsd:int")) {
            return Integer.TYPE;
        }
        if (type.startsWith("xsd:base64Binary")) {
            return byte[].class;
        }
        if (type.startsWith("Email")) {
            return Email.class;
        }
        type = type.replaceAll("^.*:", "");
        type = type.replaceAll("_", "");
        type = type.replaceAll("\\[.*\\]", "");
        return Class.forName(String.valueOf(this.packageName) + "." + type);
    }

    public Object deserializeDOM(Node node) throws Exception {
        Class nodeClass = this.getJavaClassForNode(node);
        if (nodeClass == null) {
            return null;
        }
        if (nodeClass == String.class) {
            if (node.getFirstChild() == null) {
                return "";
            }
            return node.getFirstChild().getNodeValue();
        }
        if (nodeClass.isPrimitive()) {
            String nodeValue = node.getFirstChild().getNodeValue();
            if (nodeClass == Integer.TYPE) {
                return Integer.valueOf(nodeValue);
            }
            if (nodeClass == Long.TYPE) {
                return Long.valueOf(nodeValue);
            }
            if (nodeClass == Boolean.TYPE) {
                return Boolean.valueOf(nodeValue);
            }
        } else {
            if (nodeClass == BigInteger.class) {
                return new BigInteger(node.getFirstChild().getNodeValue());
            }
            if (nodeClass == EmailLocation.class) {
                return EmailLocation.valueOf((String)node.getFirstChild().getNodeValue());
            }
            if (nodeClass == EmailState.class) {
                return EmailState.valueOf((String)node.getFirstChild().getNodeValue());
            }
            if (nodeClass == Date.class) {
                if (!node.hasChildNodes()) {
                    return null;
                }
                try {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss z");
                    return format.parse(String.valueOf(node.getFirstChild().getNodeValue()) + " UTC");
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (nodeClass == Base64.class) {
                return Base64.getMimeDecoder().decode(node.getFirstChild().getNodeValue());
            }
            if (nodeClass == byte[].class) {
                return Base64.getMimeDecoder().decode(node.getFirstChild().getNodeValue());
            }
            if (nodeClass.isArray()) {
                NodeList nodeChilds = node.getChildNodes();
                Class arrayClass = this.getJavaClassForArray(node);
                if (arrayClass == null) {
                    return null;
                }
                Object array = Array.newInstance(arrayClass, nodeChilds.getLength());
                int i = 0;
                while (i < nodeChilds.getLength()) {
                    Array.set(array, i, this.deserializeDOM(nodeChilds.item(i)));
                    ++i;
                }
                return array;
            }
            Object instance = nodeClass.newInstance();
            if (node.hasChildNodes()) {
                NodeList childs = node.getChildNodes();
                int i = 0;
                while (i < childs.getLength()) {
                    block35: {
                        Node currentChild = childs.item(i);
                        Object deserialized = null;
                        try {
                            deserialized = this.deserializeDOM(currentChild);
                            Field currentChildField = RPCDeserializer.getField(nodeClass, currentChild.getNodeName());
                            currentChildField.setAccessible(true);
                            if (deserialized instanceof byte[] && currentChildField.getType() == String.class) {
                                currentChildField.set(instance, new String((byte[])deserialized, "UTF-8"));
                            } else if (deserialized instanceof String) {
                                if (deserialized.toString().equals("") && currentChildField.getType() != String.class) {
                                    currentChildField.set(instance, null);
                                } else {
                                    currentChildField.set(instance, new String(deserialized.toString().getBytes(), "UTF-8"));
                                }
                            } else if (deserialized instanceof Integer && currentChildField.getType() == BigInteger.class) {
                                currentChildField.set(instance, new BigInteger(deserialized.toString()));
                            } else if (deserialized instanceof int[] && currentChildField.getType() == BigInteger[].class) {
                                int[] src = (int[])deserialized;
                                BigInteger[] tmp = new BigInteger[src.length];
                                int j = 0;
                                while (j < src.length) {
                                    tmp[j] = new BigInteger(Integer.toString(src[j]));
                                    ++j;
                                }
                                currentChildField.set(instance, tmp);
                            } else {
                                currentChildField.set(instance, deserialized);
                            }
                        }
                        catch (Exception e) {
                            if (!SOAPClient.isDebug()) break block35;
                            System.err.println("WARNING (soapclient): problems with tag <" + currentChild.getNodeName() + ">: " + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
            return instance;
        }
        return null;
    }

    private static Field getField(Class clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return RPCDeserializer.getField(superClass, fieldName);
        }
    }
}

