/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.result;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.result.ResultSetException;
import org.jdbi.v3.core.result.ResultSetResultIterator;
import org.jdbi.v3.core.result.StreamCallback;
import org.jdbi.v3.core.result.StreamConsumer;
import org.jdbi.v3.core.statement.StatementContext;

@FunctionalInterface
public interface ResultIterable<T>
extends Iterable<T> {
    public static <T> ResultIterable<T> of(Supplier<ResultSet> supplier, RowMapper<T> mapper, StatementContext ctx) {
        return () -> {
            try {
                return new ResultSetResultIterator((ResultSet)supplier.get(), mapper, ctx);
            }
            catch (SQLException e) {
                try {
                    ctx.close();
                }
                catch (Exception e1) {
                    e.addSuppressed(e1);
                }
                throw new ResultSetException("Unable to iterator result set", e, ctx);
            }
        };
    }

    public static <T> ResultIterable<T> of(ResultIterator<T> iterator) {
        return () -> iterator;
    }

    @Override
    public ResultIterator<T> iterator();

    default public <U> ResultIterable<U> map(final Function<? super T, ? extends U> mapper) {
        return () -> new ResultIterator<U>(){
            private final ResultIterator<T> delegate;
            {
                this.delegate = ResultIterable.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public U next() {
                return mapper.apply(this.delegate.next());
            }

            @Override
            public StatementContext getContext() {
                return this.delegate.getContext();
            }

            @Override
            public void close() {
                this.delegate.close();
            }
        };
    }

    @Override
    default public void forEach(Consumer<? super T> action) {
        try (Iterator iterator = this.iterator();){
            iterator.forEachRemaining(action);
        }
    }

    default public T one() {
        try (Iterator iter = this.iterator();){
            if (!iter.hasNext()) {
                throw new IllegalStateException("Expected one element, but found none");
            }
            Object r = iter.next();
            if (iter.hasNext()) {
                throw new IllegalStateException("Expected one element, but found multiple");
            }
            Object e = r;
            return (T)e;
        }
    }

    default public Optional<T> findOne() {
        try (Iterator iter = this.iterator();){
            if (!iter.hasNext()) {
                Optional optional = Optional.empty();
                return optional;
            }
            Object r = iter.next();
            if (iter.hasNext()) {
                throw new IllegalStateException("Expected zero to one elements, but found multiple");
            }
            Optional optional = Optional.ofNullable(r);
            return optional;
        }
    }

    @Deprecated
    default public T findOnly() {
        return this.one();
    }

    default public T first() {
        try (Iterator iter = this.iterator();){
            if (!iter.hasNext()) {
                throw new IllegalStateException("Expected at least one element, but found none");
            }
            Object e = iter.next();
            return (T)e;
        }
    }

    default public Optional<T> findFirst() {
        try (Iterator iter = this.iterator();){
            Optional optional = iter.hasNext() ? Optional.ofNullable(iter.next()) : Optional.empty();
            return optional;
        }
    }

    default public Stream<T> stream() {
        Iterator iterator = this.iterator();
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false).onClose(((ResultIterator)iterator)::close);
    }

    default public <X extends Exception> void useStream(StreamConsumer<T, X> consumer) throws X {
        this.withStream(stream -> {
            consumer.useStream(stream);
            return null;
        });
    }

    default public <R, X extends Exception> R withStream(StreamCallback<T, R, X> callback) throws X {
        try (Stream<T> stream = this.stream();){
            R r = callback.withStream(stream);
            return r;
        }
    }

    default public List<T> list() {
        return this.collect(Collectors.toList());
    }

    default public <R> R collect(Collector<? super T, ?, R> collector) {
        try (Stream<? super T> stream = this.stream();){
            R r = stream.collect(collector);
            return r;
        }
    }

    default public <U> U reduce(U identity, BiFunction<U, T, U> accumulator) {
        try (Stream<T> stream = this.stream();){
            U u2 = stream.reduce(identity, accumulator, (u, v) -> {
                throw new UnsupportedOperationException("parallel operation not supported");
            });
            return u2;
        }
    }
}

