/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.PublicKeyTLV;
import de.cardcontact.tlv.IntegerTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAPublicKeySpec;

public class RSAPublicKeyTLV
extends PublicKeyTLV {
    static final Tag TAG_MODULUS = new Tag(1, -128, false);
    static final Tag TAG_EXPONENT = new Tag(2, -128, false);
    static final String NAME_MODULUS = "Modulus";
    static final String NAME_EXPONENT = "Public Exponent";

    public RSAPublicKeyTLV(ObjectIdentifier oid, RSAPublicKey pk) {
        super(oid);
        PrimitiveTLV t = new PrimitiveTLV(TAG_MODULUS, pk.getModulus().toByteArray());
        t.setName(NAME_MODULUS);
        this.add(t);
        t = new PrimitiveTLV(TAG_EXPONENT, pk.getPublicExponent().toByteArray());
        t.setName(NAME_MODULUS);
        this.add(t);
    }

    public RSAPublicKeyTLV(TLV tlv) throws TLVEncodingException {
        super(tlv);
        if (this.childs.size() != 3) {
            throw new TLVEncodingException("Public Key must contain 3 elements");
        }
        int i = 1;
        TLV t = (TLV)this.childs.get(i);
        if (!t.getTag().equals(TAG_MODULUS)) {
            throw new TLVEncodingException("Expected Modulus in Public Key");
        }
        t.setName(NAME_MODULUS);
        t = (TLV)this.childs.get(++i);
        if (!t.getTag().equals(TAG_EXPONENT)) {
            throw new TLVEncodingException("Expected Public Exponent in Public Key");
        }
        t.setName(NAME_EXPONENT);
    }

    public PublicKey getPublicKey(String providerName) {
        BigInteger modulus = new BigInteger(1, ((TLV)this.childs.get(1)).getValue());
        BigInteger exponent = new BigInteger(1, ((TLV)this.childs.get(2)).getValue());
        RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
        KeyFactory fact = null;
        PublicKey key = null;
        try {
            fact = providerName != null ? KeyFactory.getInstance("RSA", providerName) : KeyFactory.getInstance("RSA");
            key = fact.generatePublic(spec);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem creating public key", e);
        }
        return key;
    }

    @Override
    public PublicKey getPublicKey(AlgorithmParameterSpec params) {
        return this.getPublicKey((String)null);
    }

    @Override
    public byte[] getEncodedForSPKI() {
        BigInteger modulus = new BigInteger(1, ((TLV)this.childs.get(1)).getValue());
        BigInteger exponent = new BigInteger(1, ((TLV)this.childs.get(2)).getValue());
        Sequence seq = new Sequence();
        seq.add(new IntegerTLV(modulus));
        seq.add(new IntegerTLV(exponent));
        return seq.getBytes();
    }
}

