/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.CertificateDate;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.time.LocalDate;

public class CertificateExpirationDate
extends CertificateDate {
    static final Tag TAG = new Tag(36, 64, false);
    static final String NAME = "Certificate Expiration Date";

    public CertificateExpirationDate(byte[] date) {
        super(TAG, date);
        if (date == null || date.length != 6) {
            throw new IllegalArgumentException("Certificate Expiration Date must be 6 byte long");
        }
        this.setName(NAME);
    }

    public CertificateExpirationDate(LocalDate date) {
        super(TAG, date);
    }

    public CertificateExpirationDate(TLV tlv) throws TLVEncodingException {
        super(tlv);
        if (!tlv.getTag().equals(TAG)) {
            throw new TLVEncodingException("Certificate Expiration Date with wrong tag " + String.valueOf(tlv.getTag()));
        }
        if (tlv.getLength() != 6) {
            throw new IllegalArgumentException("Certificate Expiration Date must be 6 byte long");
        }
        this.setName(NAME);
    }
}

