/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.CVCertificate;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.opencard.eac.cvc.SignatureTLV;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;

public class AuthenticatedRequest
extends ConstructedTLV {
    public static final Tag TAG = new Tag(7, 64, true);
    static final String NAME = "Authentication";

    public AuthenticatedRequest(CVCertificate cert, CertificationAuthorityReference car, SignatureTLV signature) {
        super(TAG);
        this.setName(NAME);
        this.add(cert);
        this.add(car);
        this.add(signature);
    }

    public AuthenticatedRequest(TLV tlv) throws TLVEncodingException {
        super(tlv);
        this.setName(NAME);
        if (!tlv.getTag().equals(TAG)) {
            throw new TLVEncodingException("Authentication with wrong tag " + String.valueOf(tlv.getTag()));
        }
        if (this.childs.size() != 3) {
            throw new TLVEncodingException("Authentication must contain 3 elements");
        }
        this.childs.set(0, new CVCertificate((TLV)this.childs.get(0)));
        this.childs.set(1, new CertificationAuthorityReference((TLV)this.childs.get(1)));
        this.childs.set(2, new SignatureTLV((TLV)this.childs.get(2)));
    }

    public CVCertificate getCVCertificate() {
        return (CVCertificate)this.childs.get(0);
    }

    public CertificationAuthorityReference getCertificationAuthorityReference() {
        return (CertificationAuthorityReference)this.childs.get(1);
    }

    public SignatureTLV getSignatureTLV() {
        return (SignatureTLV)this.childs.get(2);
    }
}

